{{-- Floating menus --}}
<div
    class="tiptap-floating-menu flex flex-nowrap items-center gap-1 rounded-xl bg-foreground/80 p-px [&_.is-active]:!bg-background/40"
    x-cloak
>
    {{-- set paragraph --}}
    <button
        class="rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary"
        @click.prevent='$store.tiptapEditor.setParagraph()'
    >
        <x-tabler-pilcrow class="size-4" />
    </button>
    {{-- blockquote button --}}
    <button
        class="rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary"
        @click.prevent='$store.tiptapEditor.toggleBlockquote()'
        :class="$store.tiptapEditor.isActive('blockquote', $store.tiptapEditor._updated_at) ? 'is-active' : ''"
    >
        <x-tabler-blockquote class="size-4" />
    </button>

    {{-- ordered list --}}
    <button
        class="rounded-md bg-transparent p-2 leading-none text-background"
        @click.prevent='$store.tiptapEditor.toggleOrderedList()'
        :class="$store.tiptapEditor.isActive('orderedList', $store.tiptapEditor._updated_at) ? 'is-active' : ''"
    >
        <x-tabler-list-numbers class="size-4" />
    </button>

    {{-- bullet list --}}
    <button
        class="rounded-md bg-transparent p-2 leading-none text-background"
        @click.prevent='$store.tiptapEditor.toggleBulletList()'
        :class="$store.tiptapEditor.isActive('bulletList', $store.tiptapEditor._updated_at) ? 'is-active' : ''"
    >
        <x-tabler-list class="size-4" />
    </button>

    {{-- heading --}}
    <x-dropdown.dropdown>
        <x-slot:trigger>
            <button class="rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary">
                <x-tabler-heading class="size-4" />
            </button>
        </x-slot:trigger>
        <x-slot:dropdown>
            <div class="flex flex-col">
                <button
                    class="group w-full rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary"
                    @click.prevent='$store.tiptapEditor.setHeading({level: 1})'
                >
                    <h1 class="mb-0 text-start group-hover:text-white">H1</h1>
                </button>
                <button
                    class="group w-full rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary"
                    @click.prevent='$store.tiptapEditor.setHeading({level: 2})'
                >
                    <h2 class="mb-0 text-start group-hover:text-white">H2</h2>
                </button>
                <button
                    class="group w-full rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary"
                    @click.prevent='$store.tiptapEditor.setHeading({level: 3})'
                >
                    <h3 class="mb-0 text-start group-hover:text-white">H3</h3>
                </button>
                <button
                    class="group w-full rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary"
                    @click.prevent='$store.tiptapEditor.setHeading({level: 4})'
                >
                    <h4 class="mb-0 text-start group-hover:text-white">H4</h4>
                </button>
                <button
                    class="group w-full rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary"
                    @click.prevent='$store.tiptapEditor.setHeading({level: 5})'
                >
                    <h5 class="mb-0 text-start group-hover:text-white">H5</h5>
                </button>
                <button
                    class="group w-full rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary"
                    @click.prevent='$store.tiptapEditor.setHeading({level: 6})'
                >
                    <h6 class="mb-0 text-start group-hover:text-white">H6</h6>
                </button>
            </div>
        </x-slot:dropdown>
    </x-dropdown.dropdown>

    {{-- code block --}}
    <button
        class="rounded-md bg-transparent p-2 leading-none text-background hover:bg-primary"
        @click.prevent='$store.tiptapEditor.setCodeBlock()'
        :disabled="$store.tiptapEditor.isActive('codeBlock', $store.tiptapEditor._updated_at)"
    >
        <svg
            class="size-4"
            viewBox="0 0 24 24"
            fill="currentColor"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M6.70711 2.29289C7.09763 2.68342 7.09763 3.31658 6.70711 3.70711L4.41421 6L6.70711 8.29289C7.09763 8.68342 7.09763 9.31658 6.70711 9.70711C6.31658 10.0976 5.68342 10.0976 5.29289 9.70711L2.29289 6.70711C1.90237 6.31658 1.90237 5.68342 2.29289 5.29289L5.29289 2.29289C5.68342 1.90237 6.31658 1.90237 6.70711 2.29289Z"
                fill="currentColor"
            ></path>
            <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M10.2929 2.29289C10.6834 1.90237 11.3166 1.90237 11.7071 2.29289L14.7071 5.29289C15.0976 5.68342 15.0976 6.31658 14.7071 6.70711L11.7071 9.70711C11.3166 10.0976 10.6834 10.0976 10.2929 9.70711C9.90237 9.31658 9.90237 8.68342 10.2929 8.29289L12.5858 6L10.2929 3.70711C9.90237 3.31658 9.90237 2.68342 10.2929 2.29289Z"
                fill="currentColor"
            ></path>
            <path
                fill-rule="evenodd"
                clip-rule="evenodd"
                d="M17 4C17 3.44772 17.4477 3 18 3H19C20.6569 3 22 4.34315 22 6V18C22 19.6569 20.6569 21 19 21H5C3.34315 21 2 19.6569 2 18V12C2 11.4477 2.44772 11 3 11C3.55228 11 4 11.4477 4 12V18C4 18.5523 4.44772 19 5 19H19C19.5523 19 20 18.5523 20 18V6C20 5.44772 19.5523 5 19 5H18C17.4477 5 17 4.55228 17 4Z"
                fill="currentColor"
            ></path>
        </svg>
    </button>
</div>
