<?php

namespace Amamarul\LaravelJsonLocationsManager\Commands;

use Illuminate\Console\Command;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

use Illuminate\Filesystem\Filesystem;
use Amamarul\LaravelJsonLocationsManager\Models\Strings;
use Illuminate\Support\Arr;

class InstallCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amamarul:location:install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Package';

    /**
     * Create a new command instance.
     *
     * @return void
     */
     public function __construct(Filesystem $filesystem)
     {
         parent::__construct();

         $this->files = $filesystem;
     }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $directory = storage_path('amamarul-locations');

        if (!$this->files->isDirectory( $directory )) {
            $this->files->makeDirectory($directory);
        }
        if (! $this->files->isFile($directory.'/locations.sqlite')) {
            $this->files->put($directory.'/locations.sqlite', '');
            $this->createSchema();
        }
        $this->createSchema();
        $this->line('');
        $this->info('Database Created!');


        $this->importJsonStrings();
        $this->info('Json strings imported!');

        $this->line('Package installed!');
        $this->info('');

    }

    public function importArraysStrings()
    {
        /**
         * Array Strings
         */
        $files = $this->files->directories(base_path('lang'));
        $all = [];
        $langs = [];
        $codes = [];
        foreach ($files as $key => $value) {
            $lang = array_last(explode('/',$value));
            if ($lang !== 'vendor' ) {
                array_push($langs,$lang);
                $a = $this->files->allFiles($value);
                $array = [];
                foreach ($a as $k => $v) {
                    $m = explode('.php',array_last(explode('/',$v)))[0];
                    array_push($array,array_dot([$m => include($v)]));
                }

                list($keys, $values) = array_divide(array_collapse($array));

                array_push($codes,$keys);
                array_push($all,[$lang => array_collapse($array)]);
            }
        }
        $languages = array_collapse($all);
        $codigos = collect(array_collapse($codes))->unique();

        $this->isInTable($langs);

        $collect = collect();
        foreach ($codigos as $key => $codigo) {
            $fila = [];
            foreach ($languages as $key => $arr) {
                if (array_has($arr, $codigo)) {
                    array_push($fila,[$key => array_get($arr, $codigo)]);
                }
            }
            $collect->push(array_collapse($fila));
        }
        $this->fill($collect);
        // return 'ok';
    }

    public function importJsonStrings()
    {
        /**
         * Json Strings
         */
         $json_files = $this->files->files(base_path('lang'));
         $all = [];
         $langs = [];
         $codes = [];
         foreach ($json_files as $key => $json_file) {
             if (str_contains($json_file, '.json')) {
                 $lang = Arr::first(explode('.json', basename($json_file)));
                 array_push($langs,$lang);

                 $array = json_decode($this->files->get($json_file));

                 $keys = collect($array)->keys();

                 array_push($codes,$keys);

                 array_push($all,[$lang => $array ]);
             }
         }
        $languages = Arr::collapse($all);
        $codigos = collect(Arr::collapse($codes))->unique();

        $this->isInTable($langs);
        
        $collect = collect();
        foreach ($codigos as $key => $codigo) {
            $fila = [];
            array_push($fila,['en' => $codigo]);
            foreach ($languages as $key => $arr) {
                if( $key == 'en' ){
                    continue;
                }
                $arr = (array) $arr;
                if (Arr::has($arr, $codigo)) {
                    // dd(Arr::get($arr, $codigo));
                    array_push($fila, [$key => $arr[$codigo]]);
                }
            }
            $collect->push(Arr::collapse($fila));
        }
        $this->fill($collect);
    }

    public function fill($collect)
    {
        foreach ($collect as $key => $value) {
            // dd($value['en']);
            if (!Arr::has($value, 'en')) {
                $array = collect($value);
                $array->prepend(Arr::first($value), 'en');

                $string = Strings::where('en',$array['en'])->first();
                if (!isset($string->code)) {
                    Strings::create($array->toArray());
                }
            } else {
                $string = Strings::where('en',$value['en'])->first();
                if (!isset($string->code)) {
                    Strings::create($value);
                }
            }
        }
    }

    public function createSchema()
    {
        if (!Schema::connection('locations')->hasTable('strings')) {
            Schema::connection('locations')->create('strings', function (Blueprint $table) {
                $table->increments('code')->unsigned();
                $table->text('en')->unique();
                $table->text('ar')->nullable();
                $table->text('da')->nullable();
                $table->text('de')->nullable();
                $table->text('el')->nullable();
                $table->text('es')->nullable();
                $table->text('fr')->nullable();
                $table->text('id')->nullable();
                $table->text('it')->nullable();
                $table->text('nl')->nullable();
                $table->text('pt_BR')->nullable();
                $table->text('sv')->nullable();
                $table->text('th')->nullable();
                $table->timestamps();
            });
        }
    }

    public function isInTable($langs)
    {
        $fields = \DB::connection('locations')->getSchemaBuilder()->getColumnListing('strings');
        foreach ($langs as $key => $value) {
            if (! in_array( $value, $fields )) {
                Schema::connection('locations')->table('strings', function (Blueprint $table) use($value){
                        $table->text($value)->nullable();
                    });
            }
        }
    }

}
