<?php

namespace App\Helpers\Classes;

use App\Models\OpenAIGenerator;
use App\Models\Plan;
use Illuminate\Support\Facades\Auth;

class MenuHelper
{
    public $userPlan = null;

    public $generators = null;

    public $freeOpenAiItems = null;

    public $user = null;

    public array $routesDoesNotHaveAnySlug = [
        'ai_editor',
        'ai_writer',
        'ai_chat_all',
        'ai_chat_all',
        'ai_plagiarism',
        'ai_content_detect',
        'ai_article_wizard_generator',
        'ai_webchat',
        'ai_rewriter',
        'seo',
        'brand_voice',
        'support',
        'photo_studio_extension',
        'ai_social_media_extension',
        'ai_social_media_extension',
        'ext_chat_bot',
    ];

    public array $slugsNotInOpenAiGenerator = ['ai_chat_all', 'ai_editor', 'ai_writer', 'ai_social_media_extension', 'ext_chat_bot', 'brand_voice', 'photo_studio_extension'];

    public function __construct()
    {
        $this->generators = OpenAIGenerator::query()
            ->whereIn('slug', $this->routesDoesNotHaveAnySlug)
            ->where('active', 1)
            ->get();

        $this->freeOpenAiItems = Helper::setting('free_open_ai_items');

        $this->user = Auth::user();

        if ($this->user?->getAttribute('team_manager_id')) {
            $this->user = $this->user?->getAttribute('teamManager');
        }

        $this->userPlan = $this->user->relationPlan;

    }

    public function checker(string $slug)
    {
        $data = $this->routesDoesNotHaveAnySlug + $this->slugsNotInOpenAiGenerator + $this->freeOpenAiItems;

        if (! in_array($slug, $data)) {
            return true;
        }

        if (Auth::user()->isAdmin()) {
            return true;
        }
        $plan = $this?->userPlan;

        $openAi = $this->generators
            ->where('slug', $slug)
            ->first();

        if (! $plan) {
            // if no plan then its free user, can access all templates and features with credits they have except the premium
            if (in_array($slug, $this->freeOpenAiItems, true)) {
                return true;
            }

            return $openAi?->getAttribute('premium') !== 1;
        }

        if ($openAi || in_array($slug, $this->slugsNotInOpenAiGenerator, true)) {
            $setting = $this->settingSlug($slug);
            if ($setting['status']) {
                $setting = Helper::setting($setting['setting']);
                // abort if the feature is disabled, we don't need to return a message
                if ($setting === 0) {
                    return false;
                }
            }

            if ($plan->checkOpenAiItem($slug)) {
                return true;
            }
        }
    }

    public function settingSlug($slug): array
    {
        $data = [
            'ai_article_wizard_generator' => 'feature_ai_article_wizard',
            'ai_writer'                   => 'feature_ai_writer',
            'ai_rewriter'                 => 'feature_ai_rewriter',
            'ai_chat_image'               => 'feature_ai_chat_image',
            'ai_image_generator'          => 'feature_ai_image',
            'ai_code_generator'           => 'feature_ai_code',
            'ai_speech_to_text'           => 'feature_ai_speech_to_text',
            'ai_voiceover'                => 'feature_ai_voiceover',
            'ai_vision'                   => 'feature_ai_vision',
            'ai_pdf'                      => 'feature_ai_pdf',
            'ai_youtube'                  => 'feature_ai_youtube',
            'ai_rss'                      => 'feature_ai_youtube',
        ];

        if (array_key_exists($slug, $data)) {
            return [
                'status'  => true,
                'setting' => $data[$slug],
            ];
        }

        return [
            'status' => false,
        ];
    }
}
