@extends('panel.layout.app')
@section('title', __('AI Plagiarism Checker'))

@section('content')
    <div class="page-header">
        <div class="container-xl">
            <div class="items-center flex flex-wrap justify-between">
                <div class="grow">
                    <a href="{{ LaravelLocalization::localizeUrl(route('dashboard.index')) }}"
                        class="flex items-center page-pretitle">
                        <svg class="!me-2 rtl:-scale-x-100" width="8" height="10" viewBox="0 0 6 10" fill="currentColor"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M4.45536 9.45539C4.52679 9.45539 4.60714 9.41968 4.66071 9.36611L5.10714 8.91968C5.16071 8.86611 5.19643 8.78575 5.19643 8.71432C5.19643 8.64289 5.16071 8.56254 5.10714 8.50896L1.59821 5.00004L5.10714 1.49111C5.16071 1.43753 5.19643 1.35718 5.19643 1.28575C5.19643 1.20539 5.16071 1.13396 5.10714 1.08039L4.66071 0.633963C4.60714 0.580392 4.52679 0.544678 4.45536 0.544678C4.38393 0.544678 4.30357 0.580392 4.25 0.633963L0.0892856 4.79468C0.0357141 4.84825 0 4.92861 0 5.00004C0 5.07146 0.0357141 5.15182 0.0892856 5.20539L4.25 9.36611C4.30357 9.41968 4.38393 9.45539 4.45536 9.45539Z" />
                        </svg>
                        {{ __('Back to dashboard') }}
                    </a>
                    <h2 class="mb-2 page-title">
                        {{ __('AI Plagiarism Checker') }}
                    </h2>
                    <p class="mt-3">
                        {{ __('Analyze text, comparing it against a vast database online content to identify potential plagiarism') }}
                    </p>
                </div>
                <div class="flex sm:justify-end justify-between items-center flex-wrap mt-3 lg:grow-0 grow">
                    <div class="mx-1 grow">
                        <div class="max-w-[300px]">
                            <div class="flex flex-col mb-2 ">
                                <div class="d-flex align-items-center">
                                    <span>{{ __('Remaining Credits') }}</span>
                                    <span class="ms-2" id="remaining_word_cnt">
                                        @if (Auth::user()->remaining_words == -1)
                                            Unlimited
                                        @else
                                            {{ number_format((int) Auth::user()->remaining_words) }}
                                        @endif
                                    </span>
                                </div>
                            </div>
                            <div class="mb-2 progress progress-separated" id="remaining_progress_bar">
                                @if ((int) Auth::user()->remaining_words + (int) Auth::user()->remaining_images != 0)
                                    <div class="progress-bar grow-0 shrink-0 basis-auto bg-primary" role="progressbar"
                                        style="width: {{ ((int) Auth::user()->remaining_words / ((int) Auth::user()->remaining_words + (int) Auth::user()->remaining_images)) * 100 }}%"
                                        aria-label="{{ __('Text') }}"></div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="flex justify-between sm:justify-end items-center grow">
                        <div class="mx-1">
                            <div>
                                <a class="btn me-auto"
                                    href="{{ route('dashboard.user.openai.documents.all') }}">{{ __('My Documents') }}</a>
                            </div>
                        </div>
                        <div class="mx-1">
                            <div>
                                <a class="btn btn-primary" href="/dashboard/user/openai/plagiarism">+
                                    {{ __('New') }}</a>
                            </div>
                        </div>
                        <div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Page body -->
    <div class="page-body page-generator pt-6">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-12 col-xl-6  lg:pr-14 sm:min-w-[500px] mt-2">
                    <form id="scan_content_form" onsubmit="return sendScanRequest();" enctype="multipart/form-data">
                        <div
                            class="form-control my-3 flex justify-between py-2 px-4 items-center border-[1px] border-solid rounded-[10px] dark:border-white/5">
                            <div class="flex justify-start items-end">
                                <p class="text-[20px] font-semibold p-0 m-0 dark:text-white">{{ __('Add Content') }}</p>
                                <p class="text-[#667085] text-[12px] p-0 mx-3 my-1 font-medium" id="content_length">0/5000
                                </p>
                            </div>
                        </div>
                        <div class="mb-[20px]">
                            <textarea class="form-control tinymce default" id="content_scan" name="content_scan" rows="20" style="height: 600px"
                                required="required"></textarea>
                            <div class="form-control tinymce default hidden overflow-y-scroll" id="content_result" style="height: 600px"
                                name="content_result"></div>
                        </div>

                        <button form="scan_content_form" id="scan_btn" type="submit" onclick="return sendScanRequest()"
                            class="btn btn-primary w-100 py-[0.75em]">
                            {{ __('Scan for Plagiarism') }}
                        </button>
                    </form>
                </div>
                <div class="col-12 col-xl-6  lg:pr-14 ">
                    <div class="flex flex-col items-center">
                        <div class="font-bold text-[23px] dark:text-white">{{ __('Plagiarism Report') }}</div>
                        <div class="relative">
                            <h3
                                class="text-[23px] text-center m-0 absolute top-[calc(50%-5px)] left-1/2 -translate-x-1/2 total_percent">
                                0%
                                <br>
                                {{ __('Match') }}
                            </h3>
                            <div id="chart-credit"
                                class="relative [&_.apexcharts-legend-text]:ps-2 [&_.apexcharts-legend-text]:!pe-2 [&_.apexcharts-legend-text]:!m-0">
                            </div>
                        </div>
                        <div
                            class="p-[16px] border-[#f9f9f9] border-[1px] border-solid rounded-[10px] flex w-full justify-start  my-2 dark:border-white/5">
                            <p class="text-[16px] font-semibold text-left m-0 result_text dark:text-white">{{__('Result Found')}}</p>
                        </div>
                        <div class="w-full scan_results">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <template id="result_template">
        <div class=" flex rounded-[20px] shadow-md p-[16px]">
            <div class="w-[80%] flex flex-col justify-center items-start">
                {{-- <div class="flex items-center my-1"> --}}
                <div class="flex justify-start items-center">
                    <div class="bg-[#E6E7E9] dark:bg-white/5 w-[24px] h-[24px] rounded-[55px] mx-2 flex justify-center items-center">
                        <p class="m-0 result_index">1</p>
                    </div>
                    <a class="flex items-center my-1 result_url" target="_blank">
                        <svg class="mx-2" width="20" height="10" viewBox="0 0 20 10" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path
                                d="M8.80765 9.53843H5.03845C3.78282 9.53843 2.7125 9.09599 1.8275 8.2111C0.9425 7.32622 0.5 6.25604 0.5 5.00055C0.5 3.74507 0.9425 2.6747 1.8275 1.78945C2.7125 0.904203 3.78282 0.461578 5.03845 0.461578H8.80765V1.96153H5.03845C4.1987 1.96153 3.48235 2.258 2.8894 2.85095C2.29645 3.4439 1.99998 4.16025 1.99998 5C1.99998 5.83975 2.29645 6.5561 2.8894 7.14905C3.48235 7.742 4.1987 8.03848 5.03845 8.03848H8.80765V9.53843ZM6.25 5.74998V4.25003H13.75V5.74998H6.25ZM11.1923 9.53843V8.03848H14.9615C15.8013 8.03848 16.5176 7.742 17.1106 7.14905C17.7035 6.5561 18 5.83975 18 5C18 4.16025 17.7035 3.4439 17.1106 2.85095C16.5176 2.258 15.8013 1.96153 14.9615 1.96153H11.1923V0.461578H14.9615C16.2171 0.461578 17.2875 0.904021 18.1725 1.7889C19.0575 2.67379 19.5 3.74397 19.5 4.99945C19.5 6.25494 19.0575 7.3253 18.1725 8.21055C17.2875 9.0958 16.2171 9.53843 14.9615 9.53843H11.1923Z"
                                fill="#007AFC" />
                        </svg>
                        <p
                            class="m-0 result_url_p dark:text-white">
                            https://themeforest.net/item/...</p>
                    </a>
                </div>
                {{-- <p class="m-0 text-[16px] text-black font-medium">How to install a WordPress Plugin?
                {{-- </p> --}}
                {{-- </div> --}}
            </div>
            <div
                class="w-1/5 flex flex-col justify-between items-center">
                <p class="text-[13px] font-medium m-0" style="color: #667085;">Match</p>
                <p class="text-[14px] font-medium m-0 result_percent" style="color: #D4534A">52%</p>
            </div>
        </div>
    </template>
    <template>
        <span class="hover:bg-red-50">Hello</span>
    </template>
    <div id="contextMenu" class="absolute">
        <ul class="dropdown-menu rounded-md shadow-md p-[8px] block w-[250px] border-none">
            <li id="updateWriting" class="hover:opacity-80 p-[8px] flex justify-start items-center"><svg width="21"
                    height="22" viewBox="0 0 21 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_3443_235)">
                        <path d="M6.125 11L10.5 15.375L19.25 6.625" stroke="#9A34CD" stroke-width="1.5"
                            stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M1.75 11L6.125 15.375M10.5 11L14.875 6.625" stroke="#9A34CD" stroke-width="1.5"
                            stroke-linecap="round" stroke-linejoin="round" />
                    </g>
                    <defs>
                        <clipPath id="clip0_3443_235">
                            <rect width="21" height="21" fill="white" transform="translate(0 0.5)" />
                        </clipPath>
                    </defs>
                </svg>
                <p class="mx-2 my-0">Update Content</p>
            </li>
        </ul>
    </div>
@endsection

@section('script')

    <script>
        var total_percent = 0;
        var chart = undefined;

        function renderChart(percent) {
            const options = {
                series: [percent, 100 - percent],
                labels: [('Plagiarized'), ('Unique')],
                colors: ['#D4534A', '#1CA685'],
                chart: {
                    type: 'donut',
                    height: 205,
                },
                legend: {
                    position: 'bottom',
                    fontFamily: 'inherit',
                },
                plotOptions: {
                    pie: {
                        startAngle: -90,
                        endAngle: 90,
                        offsetY: 0,
                        donut: {
                            size: '75%',
                        }
                    },
                },
                grid: {
                    padding: {
                        bottom: -130
                    }
                },
                stroke: {
                    width: 5,
                    colors: 'var(--tblr-body-bg)'
                },
                responsive: [{
                    // breakpoint: 480,
                    options: {
                        chart: {
                            width: 280,
                            height: 250
                        },
                    }
                }],
                dataLabels: {
                    enabled: false,
                }
            };
            if (chart) {
                chart.updateSeries([percent, 100 - percent]);
            } else {
                chart = (new ApexCharts(document.getElementById('chart-credit'), options));
                chart.render();
            }
        }

        document.addEventListener("DOMContentLoaded", function() {
            "use strict";
            renderChart(total_percent);

        });
    </script>

    <script src="/assets/libs/tinymce/tinymce.min.js" defer></script>
    <script src="/assets/libs/wavesurfer/wavesurfer.js"></script>
    <script>
        var $contextMenu = $("#contextMenu");
        var selectedSentence = undefined;
        $contextMenu.hide();
        $("#content_scan").on('input', function(e) {
            $("#content_length").text($(this).val().length + "/5000");
        })
        $("body").on("contextmenu", ".sentence", function(e) {
            selectedSentence = $(this);
            $contextMenu.css({
                display: "block"
            });
            $contextMenu.css({
                display: "fixed",
                left: e.pageX,
                top: e.pageY
            });
            return false;
        });

        $('html').click(function() {
            $contextMenu.hide();
        });

        $("#updateWriting").click(function(e) {
            let formData = new FormData();
            formData.append('prompt',
                'Rewrite below content unique.');
            formData.append('content', selectedSentence.html());
            document.querySelector('#app-loading-indicator')?.classList?.remove(
                'opacity-0');
            $.ajax({
                type: "post",
                url: "/dashboard/user/openai/update-writing",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    selectedSentence.html(data.result);
                    selectedSentence.contents().unwrap();
                    document.querySelector('#app-loading-indicator')?.classList
                        ?.add('opacity-0');
                },
                error: function(data) {
                    document.querySelector('#app-loading-indicator')?.classList
                        ?.add('opacity-0');
                }
            });
        });
    </script>
    <script>
        function sendScanRequest(ev) {
            "use strict";
            ev?.preventDefault();

            if ($("#content_scan").val().length < 80) {
                toastr.warning('The length of content should be bigger than 80 characters.');
                return false;
            }

            var formData = new FormData();

            formData.append('text', $("#content_scan").val());

            document.querySelector('#app-loading-indicator')?.classList?.remove(
                'opacity-0');
            $('#scan_btn').prop('disabled', true);

            $.ajax({
                type: "post",
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}",
                },
                url: "/dashboard/user/openai/plagiarismcheck",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#scan_btn').prop('disabled', true);
                    document.querySelector('#app-loading-indicator')?.classList
                        ?.add('opacity-0');
                    let sources = data.data.report_data.sources;
                    $(".scan_results").empty();

                    for (let i = 0; i < sources.length; i++) {
                        sources[i].index = i;
                    }

                    sources.sort((a, b) => {
                        return b.plagiarism_percent - a.plagiarism_percent;
                    })

                    $("#result_text").text("Result Found(" + Math.max(sources.length, 5) + ")");

                    for (let i = 0; i < sources.length && i < 5; i++) {
                        let resultTemplate = document.querySelector("#result_template").content.cloneNode(true);
                        $(resultTemplate.querySelector('.result_index')).text(i + 1);
                        $(resultTemplate.querySelector('.result_url_p')).text(sources[i].link.name);
                        $(resultTemplate.querySelector('.result_url')).attr('href', sources[i].link.urls[0]);
                        $(resultTemplate.querySelector('.result_percent')).text(sources[i]
                            .plagiarism_percent + "%");
                        $(".scan_results").append(resultTemplate);
                    }
                    if (sources.length == 0) {
                        total_percent = 0;
                    } else {
                        total_percent = sources[0].plagiarism_percent;
                    }
                    renderChart(total_percent);
                    $(".total_percent").text(total_percent + "%\nMatch");
                    let nodes = data.data.report_data.nodes;

                    let content = $("#content_scan").text();

                    let reContent = "";

                    function getColorByNumber(number) {
                        const green = Math.floor(255 * (1 - number / 100));
                        const red = Math.floor(255 * number / 100);
                        const rgbColor = `rgba(${red}, ${green}, 0, 0.7)`;

                        return rgbColor;
                    }

                    for (let i = 0; i < nodes.length; i++) {
                        // if (nodes[i].sources.length == 0) {
                        //     reContent += " " + nodes[i].text.replace(/\n/g, "<br>");
                        // } else {
                        let tColor = "#FFC7001A";
                        for (let j = Math.min(5, sources.length) - 1; j >= 0; j--) {
                            for (let k = 0; k < nodes[i].sources.length; k++) {
                                if (nodes[i].sources[k] == sources[j].index) {
                                    tColor = "#FF01011A"
                                }
                            }
                        }
                        reContent += (
                            "<span class='sentence hover:opacity-80 cursor-pointer' style='background-color: " +
                            tColor +
                            "'>" +
                            " " + nodes[i].text.replace(/\n/g, "<br>") +
                            '</span>');
                        // }
                    }
                    reContent += ""
                    $("#content_result").removeClass('hidden');
                    $("#content_result").html(reContent);
                    $("#content_scan").hide();
                    var $contextMenu = $("#contextMenu");
                    $("body").on("contextmenu", ".sentence", function(e) {
                        $contextMenu.css({
                            display: "block"
                        });
                        $contextMenu.css({
                            display: "absolute",
                            left: e.pageX,
                            top: e.pageY
                        });
                        return false;
                    });

                    var formData_ = new FormData();

                    formData_.append('input', $("#content_scan").val());
                    formData_.append('percent', total_percent);
                    formData_.append('text', reContent);

                    $.ajax({
                        type: "post",
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}",
                        },
                        url: "/dashboard/user/openai/plagiarismsave",
                        data: formData_,
                        contentType: false,
                        processData: false,
                        success: function() {

                        }
                    });
                },
                error: function(data) {
                    toastr.warning(data.responseJSON.message);
                    console.log(data);
                    document.querySelector('#app-loading-indicator')?.classList
                        ?.add('opacity-0');
                    $('#scan_btn').prop('disabled', false);
                }
            });
            return false;
        }
    </script>
@endsection
