<?php

return [

    // Uncomment the languages that your site supports - or add new ones.
    // These are sorted by the native name, which is the order you might show them in a language selector.
    // Regional languages are sorted by their base language, so "British English" sorts as "English, British"
    'supportedLocales' => [
        'ace'         => ['name' => 'Achinese',               'script' => 'Latn', 'native' => 'Aceh', 'regional' => ''],
        'af'          => ['name' => 'Afrikaans',              'script' => 'Latn', 'native' => 'Afrikaans', 'regional' => 'af_ZA'],
        'agq'         => ['name' => 'Aghem',                  'script' => 'Latn', 'native' => 'Aghem', 'regional' => ''],
        'ak'          => ['name' => 'Akan',                   'script' => 'Latn', 'native' => 'Akan', 'regional' => 'ak_GH'],
        'an'          => ['name' => 'Aragonese',              'script' => 'Latn', 'native' => 'aragonés', 'regional' => 'an_ES'],
        'cch'         => ['name' => 'Atsam',                  'script' => 'Latn', 'native' => 'Atsam', 'regional' => ''],
        'gn'          => ['name' => 'Guaraní',                'script' => 'Latn', 'native' => 'Avañe’ẽ', 'regional' => ''],
        'ae'          => ['name' => 'Avestan',                'script' => 'Latn', 'native' => 'avesta', 'regional' => ''],
        'ay'          => ['name' => 'Aymara',                 'script' => 'Latn', 'native' => 'aymar aru', 'regional' => 'ay_PE'],
        'az'          => ['name' => 'Azerbaijani (Latin)',    'script' => 'Latn', 'native' => 'azərbaycanca', 'regional' => 'az_AZ'],
        'id'          => ['name' => 'Indonesian',             'script' => 'Latn', 'native' => 'Bahasa Indonesia', 'regional' => 'id_ID'],
        'ms'          => ['name' => 'Malay',                  'script' => 'Latn', 'native' => 'Bahasa Melayu', 'regional' => 'ms_MY'],
        'bm'          => ['name' => 'Bambara',                'script' => 'Latn', 'native' => 'bamanakan', 'regional' => ''],
        'jv'          => ['name' => 'Javanese (Latin)',       'script' => 'Latn', 'native' => 'Basa Jawa', 'regional' => ''],
        'su'          => ['name' => 'Sundanese',              'script' => 'Latn', 'native' => 'Basa Sunda', 'regional' => ''],
        'bh'          => ['name' => 'Bihari',                 'script' => 'Latn', 'native' => 'Bihari', 'regional' => ''],
        'bi'          => ['name' => 'Bislama',                'script' => 'Latn', 'native' => 'Bislama', 'regional' => ''],
        'nb'          => ['name' => 'Norwegian Bokmål',       'script' => 'Latn', 'native' => 'Bokmål', 'regional' => 'nb_NO'],
        'bs'          => ['name' => 'Bosnian',                'script' => 'Latn', 'native' => 'bosanski', 'regional' => 'bs_BA'],
        'br'          => ['name' => 'Breton',                 'script' => 'Latn', 'native' => 'brezhoneg', 'regional' => 'br_FR'],
        'ca'          => ['name' => 'Catalan',                'script' => 'Latn', 'native' => 'català', 'regional' => 'ca_ES'],
        'ch'          => ['name' => 'Chamorro',               'script' => 'Latn', 'native' => 'Chamoru', 'regional' => ''],
        'ny'          => ['name' => 'Chewa',                  'script' => 'Latn', 'native' => 'chiCheŵa', 'regional' => ''],
        'kde'         => ['name' => 'Makonde',                'script' => 'Latn', 'native' => 'Chimakonde', 'regional' => ''],
        'sn'          => ['name' => 'Shona',                  'script' => 'Latn', 'native' => 'chiShona', 'regional' => ''],
        'co'          => ['name' => 'Corsican',               'script' => 'Latn', 'native' => 'corsu', 'regional' => ''],
        'cy'          => ['name' => 'Welsh',                  'script' => 'Latn', 'native' => 'Cymraeg', 'regional' => 'cy_GB'],
        'da'          => ['name' => 'Danish',                 'script' => 'Latn', 'native' => 'dansk', 'regional' => 'da_DK'],
        'se'          => ['name' => 'Northern Sami',          'script' => 'Latn', 'native' => 'davvisámegiella', 'regional' => 'se_NO'],
        'de'          => ['name' => 'German',                 'script' => 'Latn', 'native' => 'Deutsch', 'regional' => 'de_DE'],
        'luo'         => ['name' => 'Luo',                    'script' => 'Latn', 'native' => 'Dholuo', 'regional' => ''],
        'nv'          => ['name' => 'Navajo',                 'script' => 'Latn', 'native' => 'Diné bizaad', 'regional' => ''],
        'dua'         => ['name' => 'Duala',                  'script' => 'Latn', 'native' => 'duálá', 'regional' => ''],
        'et'          => ['name' => 'Estonian',               'script' => 'Latn', 'native' => 'eesti', 'regional' => 'et_EE'],
        'na'          => ['name' => 'Nauru',                  'script' => 'Latn', 'native' => 'Ekakairũ Naoero', 'regional' => ''],
        'guz'         => ['name' => 'Ekegusii',               'script' => 'Latn', 'native' => 'Ekegusii', 'regional' => ''],
        'en'          => ['name' => 'English',                'script' => 'Latn', 'native' => 'English', 'regional' => 'en_US'],
        'en-AU'       => ['name' => 'Australian English',     'script' => 'Latn', 'native' => 'Australian English', 'regional' => 'en_AU'],
        'en-GB'       => ['name' => 'British English',        'script' => 'Latn', 'native' => 'British English', 'regional' => 'en_GB'],
        'en-CA'       => ['name' => 'Canadian English',       'script' => 'Latn', 'native' => 'Canadian English', 'regional' => 'en_CA'],
        'en-US'       => ['name' => 'U.S. English',           'script' => 'Latn', 'native' => 'U.S. English', 'regional' => 'en_US', 'phone_code' => '1'],
        'es'          => ['name' => 'Spanish',                'script' => 'Latn', 'native' => 'español', 'regional' => 'es_ES'],
        'eo'          => ['name' => 'Esperanto',              'script' => 'Latn', 'native' => 'esperanto', 'regional' => ''],
        'eu'          => ['name' => 'Basque',                 'script' => 'Latn', 'native' => 'euskara', 'regional' => 'eu_ES'],
        'ewo'         => ['name' => 'Ewondo',                 'script' => 'Latn', 'native' => 'ewondo', 'regional' => ''],
        'ee'          => ['name' => 'Ewe',                    'script' => 'Latn', 'native' => 'eʋegbe', 'regional' => ''],
        'fil'         => ['name' => 'Filipino',               'script' => 'Latn', 'native' => 'Filipino', 'regional' => 'fil_PH'],
        'fr'          => ['name' => 'French',                 'script' => 'Latn', 'native' => 'français', 'regional' => 'fr_FR'],
        'fr-CA'       => ['name' => 'Canadian French',        'script' => 'Latn', 'native' => 'français canadien', 'regional' => 'fr_CA'],
        'fy'          => ['name' => 'Western Frisian',        'script' => 'Latn', 'native' => 'frysk', 'regional' => 'fy_DE'],
        'fur'         => ['name' => 'Friulian',               'script' => 'Latn', 'native' => 'furlan', 'regional' => 'fur_IT'],
        'fo'          => ['name' => 'Faroese',                'script' => 'Latn', 'native' => 'føroyskt', 'regional' => 'fo_FO'],
        'gaa'         => ['name' => 'Ga',                     'script' => 'Latn', 'native' => 'Ga', 'regional' => ''],
        'ga'          => ['name' => 'Irish',                  'script' => 'Latn', 'native' => 'Gaeilge', 'regional' => 'ga_IE'],
        'gv'          => ['name' => 'Manx',                   'script' => 'Latn', 'native' => 'Gaelg', 'regional' => 'gv_GB'],
        'sm'          => ['name' => 'Samoan',                 'script' => 'Latn', 'native' => 'Gagana fa’a Sāmoa', 'regional' => ''],
        'gl'          => ['name' => 'Galician',               'script' => 'Latn', 'native' => 'galego', 'regional' => 'gl_ES'],
        'ki'          => ['name' => 'Kikuyu',                 'script' => 'Latn', 'native' => 'Gikuyu', 'regional' => ''],
        'gd'          => ['name' => 'Scottish Gaelic',        'script' => 'Latn', 'native' => 'Gàidhlig', 'regional' => 'gd_GB'],
        'ha'          => ['name' => 'Hausa',                  'script' => 'Latn', 'native' => 'Hausa', 'regional' => 'ha_NG'],
        'bez'         => ['name' => 'Bena',                   'script' => 'Latn', 'native' => 'Hibena', 'regional' => ''],
        'ho'          => ['name' => 'Hiri Motu',              'script' => 'Latn', 'native' => 'Hiri Motu', 'regional' => ''],
        'hr'          => ['name' => 'Croatian',               'script' => 'Latn', 'native' => 'hrvatski', 'regional' => 'hr_HR'],
        'bem'         => ['name' => 'Bemba',                  'script' => 'Latn', 'native' => 'Ichibemba', 'regional' => 'bem_ZM'],
        'io'          => ['name' => 'Ido',                    'script' => 'Latn', 'native' => 'Ido', 'regional' => ''],
        'ig'          => ['name' => 'Igbo',                   'script' => 'Latn', 'native' => 'Igbo', 'regional' => 'ig_NG'],
        'rn'          => ['name' => 'Rundi',                  'script' => 'Latn', 'native' => 'Ikirundi', 'regional' => ''],
        'ia'          => ['name' => 'Interlingua',            'script' => 'Latn', 'native' => 'interlingua', 'regional' => 'ia_FR'],
        'iu-Latn'     => ['name' => 'Inuktitut (Latin)',      'script' => 'Latn', 'native' => 'Inuktitut', 'regional' => 'iu_CA'],
        'sbp'         => ['name' => 'Sileibi',                'script' => 'Latn', 'native' => 'Ishisangu', 'regional' => ''],
        'nd'          => ['name' => 'North Ndebele',          'script' => 'Latn', 'native' => 'isiNdebele', 'regional' => ''],
        'nr'          => ['name' => 'South Ndebele',          'script' => 'Latn', 'native' => 'isiNdebele', 'regional' => 'nr_ZA'],
        'xh'          => ['name' => 'Xhosa',                  'script' => 'Latn', 'native' => 'isiXhosa', 'regional' => 'xh_ZA'],
        'zu'          => ['name' => 'Zulu',                   'script' => 'Latn', 'native' => 'isiZulu', 'regional' => 'zu_ZA'],
        'it'          => ['name' => 'Italian',                'script' => 'Latn', 'native' => 'italiano', 'regional' => 'it_IT'],
        'ik'          => ['name' => 'Inupiaq',                'script' => 'Latn', 'native' => 'Iñupiaq', 'regional' => 'ik_CA'],
        'dyo'         => ['name' => 'Jola-Fonyi',             'script' => 'Latn', 'native' => 'joola', 'regional' => ''],
        'kea'         => ['name' => 'Kabuverdianu',           'script' => 'Latn', 'native' => 'kabuverdianu', 'regional' => ''],
        'kaj'         => ['name' => 'Jju',                    'script' => 'Latn', 'native' => 'Kaje', 'regional' => ''],
        'mh'          => ['name' => 'Marshallese',            'script' => 'Latn', 'native' => 'Kajin M̧ajeļ', 'regional' => 'mh_MH'],
        'kl'          => ['name' => 'Kalaallisut',            'script' => 'Latn', 'native' => 'kalaallisut', 'regional' => 'kl_GL'],
        'kln'         => ['name' => 'Kalenjin',               'script' => 'Latn', 'native' => 'Kalenjin', 'regional' => ''],
        'kr'          => ['name' => 'Kanuri',                 'script' => 'Latn', 'native' => 'Kanuri', 'regional' => ''],
        'kcg'         => ['name' => 'Tyap',                   'script' => 'Latn', 'native' => 'Katab', 'regional' => ''],
        'kw'          => ['name' => 'Cornish',                'script' => 'Latn', 'native' => 'kernewek', 'regional' => 'kw_GB'],
        'naq'         => ['name' => 'Nama',                   'script' => 'Latn', 'native' => 'Khoekhoegowab', 'regional' => ''],
        'rof'         => ['name' => 'Rombo',                  'script' => 'Latn', 'native' => 'Kihorombo', 'regional' => ''],
        'kam'         => ['name' => 'Kamba',                  'script' => 'Latn', 'native' => 'Kikamba', 'regional' => ''],
        'kg'          => ['name' => 'Kongo',                  'script' => 'Latn', 'native' => 'Kikongo', 'regional' => ''],
        'jmc'         => ['name' => 'Machame',                'script' => 'Latn', 'native' => 'Kimachame', 'regional' => ''],
        'rw'          => ['name' => 'Kinyarwanda',            'script' => 'Latn', 'native' => 'Kinyarwanda', 'regional' => 'rw_RW'],
        'asa'         => ['name' => 'Kipare',                 'script' => 'Latn', 'native' => 'Kipare', 'regional' => ''],
        'rwk'         => ['name' => 'Rwa',                    'script' => 'Latn', 'native' => 'Kiruwa', 'regional' => ''],
        'saq'         => ['name' => 'Samburu',                'script' => 'Latn', 'native' => 'Kisampur', 'regional' => ''],
        'ksb'         => ['name' => 'Shambala',               'script' => 'Latn', 'native' => 'Kishambaa', 'regional' => ''],
        'swc'         => ['name' => 'Congo Swahili',          'script' => 'Latn', 'native' => 'Kiswahili ya Kongo', 'regional' => ''],
        'sw'          => ['name' => 'Swahili',                'script' => 'Latn', 'native' => 'Kiswahili', 'regional' => 'sw_KE'],
        'dav'         => ['name' => 'Dawida',                 'script' => 'Latn', 'native' => 'Kitaita', 'regional' => ''],
        'teo'         => ['name' => 'Teso',                   'script' => 'Latn', 'native' => 'Kiteso', 'regional' => ''],
        'khq'         => ['name' => 'Koyra Chiini',           'script' => 'Latn', 'native' => 'Koyra ciini', 'regional' => ''],
        'ses'         => ['name' => 'Songhay',                'script' => 'Latn', 'native' => 'Koyraboro senni', 'regional' => ''],
        'mfe'         => ['name' => 'Morisyen',               'script' => 'Latn', 'native' => 'kreol morisien', 'regional' => ''],
        'ht'          => ['name' => 'Haitian',                'script' => 'Latn', 'native' => 'Kreyòl ayisyen', 'regional' => 'ht_HT'],
        'kj'          => ['name' => 'Kuanyama',               'script' => 'Latn', 'native' => 'Kwanyama', 'regional' => ''],
        'ksh'         => ['name' => 'Kölsch',                 'script' => 'Latn', 'native' => 'Kölsch', 'regional' => ''],
        'ebu'         => ['name' => 'Kiembu',                 'script' => 'Latn', 'native' => 'Kĩembu', 'regional' => ''],
        'mer'         => ['name' => 'Kimîîru',                'script' => 'Latn', 'native' => 'Kĩmĩrũ', 'regional' => ''],
        'lag'         => ['name' => 'Langi',                  'script' => 'Latn', 'native' => 'Kɨlaangi', 'regional' => ''],
        'lah'         => ['name' => 'Lahnda',                 'script' => 'Latn', 'native' => 'Lahnda', 'regional' => ''],
        'la'          => ['name' => 'Latin',                  'script' => 'Latn', 'native' => 'latine', 'regional' => ''],
        'lv'          => ['name' => 'Latvian',                'script' => 'Latn', 'native' => 'latviešu', 'regional' => 'lv_LV'],
        'to'          => ['name' => 'Tongan',                 'script' => 'Latn', 'native' => 'lea fakatonga', 'regional' => ''],
        'lt'          => ['name' => 'Lithuanian',             'script' => 'Latn', 'native' => 'lietuvių', 'regional' => 'lt_LT'],
        'li'          => ['name' => 'Limburgish',             'script' => 'Latn', 'native' => 'Limburgs', 'regional' => 'li_BE'],
        'ln'          => ['name' => 'Lingala',                'script' => 'Latn', 'native' => 'lingála', 'regional' => ''],
        'lg'          => ['name' => 'Ganda',                  'script' => 'Latn', 'native' => 'Luganda', 'regional' => 'lg_UG'],
        'luy'         => ['name' => 'Oluluyia',               'script' => 'Latn', 'native' => 'Luluhia', 'regional' => ''],
        'lb'          => ['name' => 'Luxembourgish',          'script' => 'Latn', 'native' => 'Lëtzebuergesch', 'regional' => 'lb_LU'],
        'hu'          => ['name' => 'Hungarian',              'script' => 'Latn', 'native' => 'magyar', 'regional' => 'hu_HU'],
        'mgh'         => ['name' => 'Makhuwa-Meetto',         'script' => 'Latn', 'native' => 'Makua', 'regional' => ''],
        'mg'          => ['name' => 'Malagasy',               'script' => 'Latn', 'native' => 'Malagasy', 'regional' => 'mg_MG'],
        'mt'          => ['name' => 'Maltese',                'script' => 'Latn', 'native' => 'Malti', 'regional' => 'mt_MT'],
        'mtr'         => ['name' => 'Mewari',                 'script' => 'Latn', 'native' => 'Mewari', 'regional' => ''],
        'mua'         => ['name' => 'Mundang',                'script' => 'Latn', 'native' => 'Mundang', 'regional' => ''],
        'mi'          => ['name' => 'Māori',                  'script' => 'Latn', 'native' => 'Māori', 'regional' => 'mi_NZ'],
        'nl'          => ['name' => 'Dutch',                  'script' => 'Latn', 'native' => 'Nederlands', 'regional' => 'nl_NL'],
        'nmg'         => ['name' => 'Kwasio',                 'script' => 'Latn', 'native' => 'ngumba', 'regional' => ''],
        'yav'         => ['name' => 'Yangben',                'script' => 'Latn', 'native' => 'nuasue', 'regional' => ''],
        'nn'          => ['name' => 'Norwegian Nynorsk',      'script' => 'Latn', 'native' => 'nynorsk', 'regional' => 'nn_NO'],
        'oc'          => ['name' => 'Occitan',                'script' => 'Latn', 'native' => 'occitan', 'regional' => 'oc_FR'],
        'ang'         => ['name' => 'Old English',            'script' => 'Runr', 'native' => 'Old English', 'regional' => ''],
        'xog'         => ['name' => 'Soga',                   'script' => 'Latn', 'native' => 'Olusoga', 'regional' => ''],
        'om'          => ['name' => 'Oromo',                  'script' => 'Latn', 'native' => 'Oromoo', 'regional' => 'om_ET'],
        'ng'          => ['name' => 'Ndonga',                 'script' => 'Latn', 'native' => 'OshiNdonga', 'regional' => ''],
        'hz'          => ['name' => 'Herero',                 'script' => 'Latn', 'native' => 'Otjiherero', 'regional' => ''],
        'uz-Latn'     => ['name' => 'Uzbek (Latin)',          'script' => 'Latn', 'native' => 'oʼzbekcha', 'regional' => 'uz_UZ'],
        'nds'         => ['name' => 'Low German',             'script' => 'Latn', 'native' => 'Plattdüütsch', 'regional' => 'nds_DE'],
        'pl'          => ['name' => 'Polish',                 'script' => 'Latn', 'native' => 'polski', 'regional' => 'pl_PL'],
        'pt'          => ['name' => 'Portuguese',             'script' => 'Latn', 'native' => 'português', 'regional' => 'pt_PT'],
        'pt-BR'       => ['name' => 'Brazilian Portuguese',   'script' => 'Latn', 'native' => 'português do Brasil', 'regional' => 'pt_BR'],
        'ff'          => ['name' => 'Fulah',                  'script' => 'Latn', 'native' => 'Pulaar', 'regional' => 'ff_SN'],
        'pi'          => ['name' => 'Pahari-Potwari',         'script' => 'Latn', 'native' => 'Pāli', 'regional' => ''],
        'aa'          => ['name' => 'Afar',                   'script' => 'Latn', 'native' => 'Qafar', 'regional' => 'aa_ER'],
        'ty'          => ['name' => 'Tahitian',               'script' => 'Latn', 'native' => 'Reo Māohi', 'regional' => ''],
        'ksf'         => ['name' => 'Bafia',                  'script' => 'Latn', 'native' => 'rikpa', 'regional' => ''],
        'ro'          => ['name' => 'Romanian',               'script' => 'Latn', 'native' => 'română', 'regional' => 'ro_RO'],
        'cgg'         => ['name' => 'Chiga',                  'script' => 'Latn', 'native' => 'Rukiga', 'regional' => ''],
        'rm'          => ['name' => 'Romansh',                'script' => 'Latn', 'native' => 'rumantsch', 'regional' => ''],
        'qu'          => ['name' => 'Quechua',                'script' => 'Latn', 'native' => 'Runa Simi', 'regional' => ''],
        'nyn'         => ['name' => 'Nyankole',               'script' => 'Latn', 'native' => 'Runyankore', 'regional' => ''],
        'ssy'         => ['name' => 'Saho',                   'script' => 'Latn', 'native' => 'Saho', 'regional' => ''],
        'sc'          => ['name' => 'Sardinian',              'script' => 'Latn', 'native' => 'sardu', 'regional' => 'sc_IT'],
        'de-CH'       => ['name' => 'Swiss High German',      'script' => 'Latn', 'native' => 'Schweizer Hochdeutsch', 'regional' => 'de_CH'],
        'gsw'         => ['name' => 'Swiss German',           'script' => 'Latn', 'native' => 'Schwiizertüütsch', 'regional' => ''],
        'trv'         => ['name' => 'Taroko',                 'script' => 'Latn', 'native' => 'Seediq', 'regional' => ''],
        'seh'         => ['name' => 'Sena',                   'script' => 'Latn', 'native' => 'sena', 'regional' => ''],
        'nso'         => ['name' => 'Northern Sotho',         'script' => 'Latn', 'native' => 'Sesotho sa Leboa', 'regional' => 'nso_ZA'],
        'st'          => ['name' => 'Southern Sotho',         'script' => 'Latn', 'native' => 'Sesotho', 'regional' => 'st_ZA'],
        'tn'          => ['name' => 'Tswana',                 'script' => 'Latn', 'native' => 'Setswana', 'regional' => 'tn_ZA'],
        'sq'          => ['name' => 'Albanian',               'script' => 'Latn', 'native' => 'shqip', 'regional' => 'sq_AL'],
        'sid'         => ['name' => 'Sidamo',                 'script' => 'Latn', 'native' => 'Sidaamu Afo', 'regional' => 'sid_ET'],
        'ss'          => ['name' => 'Swati',                  'script' => 'Latn', 'native' => 'Siswati', 'regional' => 'ss_ZA'],
        'sk'          => ['name' => 'Slovak',                 'script' => 'Latn', 'native' => 'slovenčina', 'regional' => 'sk_SK'],
        'sl'          => ['name' => 'Slovene',                'script' => 'Latn', 'native' => 'slovenščina', 'regional' => 'sl_SI'],
        'so'          => ['name' => 'Somali',                 'script' => 'Latn', 'native' => 'Soomaali', 'regional' => 'so_SO'],
        'sr-Latn'     => ['name' => 'Serbian (Latin)',        'script' => 'Latn', 'native' => 'Srpski', 'regional' => 'sr_RS'],
        'sh'          => ['name' => 'Serbo-Croatian',         'script' => 'Latn', 'native' => 'srpskohrvatski', 'regional' => ''],
        'fi'          => ['name' => 'Finnish',                'script' => 'Latn', 'native' => 'suomi', 'regional' => 'fi_FI'],
        'sv'          => ['name' => 'Swedish',                'script' => 'Latn', 'native' => 'svenska', 'regional' => 'sv_SE'],
        'sg'          => ['name' => 'Sango',                  'script' => 'Latn', 'native' => 'Sängö', 'regional' => ''],
        'tl'          => ['name' => 'Tagalog',                'script' => 'Latn', 'native' => 'Tagalog', 'regional' => 'tl_PH'],
        'tzm-Latn'    => ['name' => 'Central Atlas Tamazight (Latin)', 'script' => 'Latn', 'native' => 'Tamazight', 'regional' => ''],
        'kab'         => ['name' => 'Kabyle',                 'script' => 'Latn', 'native' => 'Taqbaylit', 'regional' => 'kab_DZ'],
        'twq'         => ['name' => 'Tasawaq',                'script' => 'Latn', 'native' => 'Tasawaq senni', 'regional' => ''],
        'shi'         => ['name' => 'Tachelhit (Latin)',      'script' => 'Latn', 'native' => 'Tashelhit', 'regional' => ''],
        'nus'         => ['name' => 'Nuer',                   'script' => 'Latn', 'native' => 'Thok Nath', 'regional' => ''],
        'vi'          => ['name' => 'Vietnamese',             'script' => 'Latn', 'native' => 'Tiếng Việt', 'regional' => 'vi_VN'],
        'tg-Latn'     => ['name' => 'Tajik (Latin)',          'script' => 'Latn', 'native' => 'tojikī', 'regional' => 'tg_TJ'],
        'lu'          => ['name' => 'Luba-Katanga',           'script' => 'Latn', 'native' => 'Tshiluba', 'regional' => 've_ZA'],
        've'          => ['name' => 'Venda',                  'script' => 'Latn', 'native' => 'Tshivenḓa', 'regional' => ''],
        'tw'          => ['name' => 'Twi',                    'script' => 'Latn', 'native' => 'Twi', 'regional' => ''],
        'tr'          => ['name' => 'Turkish',                'script' => 'Latn', 'native' => 'Türkçe', 'regional' => 'tr_TR'],
        'ale'         => ['name' => 'Aleut',                  'script' => 'Latn', 'native' => 'Unangax tunuu', 'regional' => ''],
        'ca-valencia' => ['name' => 'Valencian',              'script' => 'Latn', 'native' => 'valencià', 'regional' => ''],
        'vai-Latn'    => ['name' => 'Vai (Latin)',            'script' => 'Latn', 'native' => 'Viyamíĩ', 'regional' => ''],
        'vo'          => ['name' => 'Volapük',                'script' => 'Latn', 'native' => 'Volapük', 'regional' => ''],
        'fj'          => ['name' => 'Fijian',                 'script' => 'Latn', 'native' => 'vosa Vakaviti', 'regional' => ''],
        'wa'          => ['name' => 'Walloon',                'script' => 'Latn', 'native' => 'Walon', 'regional' => 'wa_BE'],
        'wae'         => ['name' => 'Walser',                 'script' => 'Latn', 'native' => 'Walser', 'regional' => 'wae_CH'],
        'wen'         => ['name' => 'Sorbian',                'script' => 'Latn', 'native' => 'Wendic', 'regional' => ''],
        'wo'          => ['name' => 'Wolof',                  'script' => 'Latn', 'native' => 'Wolof', 'regional' => 'wo_SN'],
        'ts'          => ['name' => 'Tsonga',                 'script' => 'Latn', 'native' => 'Xitsonga', 'regional' => 'ts_ZA'],
        'dje'         => ['name' => 'Zarma',                  'script' => 'Latn', 'native' => 'Zarmaciine', 'regional' => ''],
        'yo'          => ['name' => 'Yoruba',                 'script' => 'Latn', 'native' => 'Èdè Yorùbá', 'regional' => 'yo_NG'],
        'de-AT'       => ['name' => 'Austrian German',        'script' => 'Latn', 'native' => 'Österreichisches Deutsch', 'regional' => 'de_AT'],
        'is'          => ['name' => 'Icelandic',              'script' => 'Latn', 'native' => 'íslenska', 'regional' => 'is_IS'],
        'cs'          => ['name' => 'Czech',                  'script' => 'Latn', 'native' => 'čeština', 'regional' => 'cs_CZ'],
        'bas'         => ['name' => 'Basa',                   'script' => 'Latn', 'native' => 'Ɓàsàa', 'regional' => ''],
        'mas'         => ['name' => 'Masai',                  'script' => 'Latn', 'native' => 'ɔl-Maa', 'regional' => ''],
        'haw'         => ['name' => 'Hawaiian',               'script' => 'Latn', 'native' => 'ʻŌlelo Hawaiʻi', 'regional' => ''],
        'el'          => ['name' => 'Greek',                  'script' => 'Grek', 'native' => 'Ελληνικά', 'regional' => 'el_GR'],
        'uz'          => ['name' => 'Uzbek (Cyrillic)',       'script' => 'Cyrl', 'native' => 'Ўзбек', 'regional' => 'uz_UZ'],
        'az-Cyrl'     => ['name' => 'Azerbaijani (Cyrillic)', 'script' => 'Cyrl', 'native' => 'Азәрбајҹан', 'regional' => 'uz_UZ'],
        'ab'          => ['name' => 'Abkhazian',              'script' => 'Cyrl', 'native' => 'Аҧсуа', 'regional' => ''],
        'os'          => ['name' => 'Ossetic',                'script' => 'Cyrl', 'native' => 'Ирон', 'regional' => 'os_RU'],
        'ky'          => ['name' => 'Kyrgyz',                 'script' => 'Cyrl', 'native' => 'Кыргыз', 'regional' => 'ky_KG'],
        'sr'          => ['name' => 'Serbian (Cyrillic)',     'script' => 'Cyrl', 'native' => 'Српски', 'regional' => 'sr_RS'],
        'av'          => ['name' => 'Avaric',                 'script' => 'Cyrl', 'native' => 'авар мацӀ', 'regional' => ''],
        'ady'         => ['name' => 'Adyghe',                 'script' => 'Cyrl', 'native' => 'адыгэбзэ', 'regional' => ''],
        'ba'          => ['name' => 'Bashkir',                'script' => 'Cyrl', 'native' => 'башҡорт теле', 'regional' => ''],
        'be'          => ['name' => 'Belarusian',             'script' => 'Cyrl', 'native' => 'беларуская', 'regional' => 'be_BY'],
        'bg'          => ['name' => 'Bulgarian',              'script' => 'Cyrl', 'native' => 'български', 'regional' => 'bg_BG'],
        'kv'          => ['name' => 'Komi',                   'script' => 'Cyrl', 'native' => 'коми кыв', 'regional' => ''],
        'mk'          => ['name' => 'Macedonian',             'script' => 'Cyrl', 'native' => 'македонски', 'regional' => 'mk_MK'],
        'mn'          => ['name' => 'Mongolian (Cyrillic)',   'script' => 'Cyrl', 'native' => 'монгол', 'regional' => 'mn_MN'],
        'ce'          => ['name' => 'Chechen',                'script' => 'Cyrl', 'native' => 'нохчийн мотт', 'regional' => 'ce_RU'],
        'ru'          => ['name' => 'Russian',                'script' => 'Cyrl', 'native' => 'русский', 'regional' => 'ru_RU'],
        'sah'         => ['name' => 'Yakut',                  'script' => 'Cyrl', 'native' => 'саха тыла', 'regional' => ''],
        'tt'          => ['name' => 'Tatar',                  'script' => 'Cyrl', 'native' => 'татар теле', 'regional' => 'tt_RU'],
        'tg'          => ['name' => 'Tajik (Cyrillic)',       'script' => 'Cyrl', 'native' => 'тоҷикӣ', 'regional' => 'tg_TJ'],
        'tk'          => ['name' => 'Turkmen',                'script' => 'Cyrl', 'native' => 'түркменче', 'regional' => 'tk_TM'],
        'uk'          => ['name' => 'Ukrainian',              'script' => 'Cyrl', 'native' => 'українська', 'regional' => 'uk_UA'],
        'cv'          => ['name' => 'Chuvash',                'script' => 'Cyrl', 'native' => 'чӑваш чӗлхи', 'regional' => 'cv_RU'],
        'cu'          => ['name' => 'Church Slavic',          'script' => 'Cyrl', 'native' => 'ѩзыкъ словѣньскъ', 'regional' => ''],
        'kk'          => ['name' => 'Kazakh',                 'script' => 'Cyrl', 'native' => 'қазақ тілі', 'regional' => 'kk_KZ'],
        'hy'          => ['name' => 'Armenian',               'script' => 'Armn', 'native' => 'Հայերեն', 'regional' => 'hy_AM'],
        'yi'          => ['name' => 'Yiddish',                'script' => 'Hebr', 'native' => 'ייִדיש', 'regional' => 'yi_US'],
        'he'          => ['name' => 'Hebrew',                 'script' => 'Hebr', 'native' => 'עברית', 'regional' => 'he_IL'],
        'ug'          => ['name' => 'Uyghur',                 'script' => 'Arab', 'native' => 'ئۇيغۇرچە', 'regional' => 'ug_CN'],
        'ur'          => ['name' => 'Urdu',                   'script' => 'Arab', 'native' => 'اردو', 'regional' => 'ur_PK'],
        'ar'          => ['name' => 'Arabic',                 'script' => 'Arab', 'native' => 'العربية', 'regional' => 'ar_AE'],
        'uz-Arab'     => ['name' => 'Uzbek (Arabic)',         'script' => 'Arab', 'native' => 'اۉزبېک', 'regional' => ''],
        'tg-Arab'     => ['name' => 'Tajik (Arabic)',         'script' => 'Arab', 'native' => 'تاجیکی', 'regional' => 'tg_TJ'],
        'sd'          => ['name' => 'Sindhi',                 'script' => 'Arab', 'native' => 'سنڌي', 'regional' => 'sd_IN'],
        'fa'          => ['name' => 'Persian',                'script' => 'Arab', 'native' => 'فارسی', 'regional' => 'fa_IR'],
        'pa-Arab'     => ['name' => 'Punjabi (Arabic)',       'script' => 'Arab', 'native' => 'پنجاب', 'regional' => 'pa_IN'],
        'ps'          => ['name' => 'Pashto',                 'script' => 'Arab', 'native' => 'پښتو', 'regional' => 'ps_AF'],
        'ks'          => ['name' => 'Kashmiri (Arabic)',      'script' => 'Arab', 'native' => 'کأشُر', 'regional' => 'ks_IN'],
        'ku'          => ['name' => 'Kurdish',                'script' => 'Arab', 'native' => 'کوردی', 'regional' => 'ku_TR'],
        'dv'          => ['name' => 'Divehi',                 'script' => 'Thaa', 'native' => 'ދިވެހިބަސް', 'regional' => 'dv_MV'],
        'ks-Deva'     => ['name' => 'Kashmiri (Devaganari)',  'script' => 'Deva', 'native' => 'कॉशुर', 'regional' => 'ks_IN'],
        'kok'         => ['name' => 'Konkani',                'script' => 'Deva', 'native' => 'कोंकणी', 'regional' => 'kok_IN'],
        'doi'         => ['name' => 'Dogri',                  'script' => 'Deva', 'native' => 'डोगरी', 'regional' => 'doi_IN'],
        'ne'          => ['name' => 'Nepali',                 'script' => 'Deva', 'native' => 'नेपाली', 'regional' => ''],
        'pra'         => ['name' => 'Prakrit',                'script' => 'Deva', 'native' => 'प्राकृत', 'regional' => ''],
        'brx'         => ['name' => 'Bodo',                   'script' => 'Deva', 'native' => 'बड़ो', 'regional' => 'brx_IN'],
        'bra'         => ['name' => 'Braj',                   'script' => 'Deva', 'native' => 'ब्रज भाषा', 'regional' => ''],
        'mr'          => ['name' => 'Marathi',                'script' => 'Deva', 'native' => 'मराठी', 'regional' => 'mr_IN'],
        'mai'         => ['name' => 'Maithili',               'script' => 'Tirh', 'native' => 'मैथिली', 'regional' => 'mai_IN'],
        'raj'         => ['name' => 'Rajasthani',             'script' => 'Deva', 'native' => 'राजस्थानी', 'regional' => ''],
        'sa'          => ['name' => 'Sanskrit',               'script' => 'Deva', 'native' => 'संस्कृतम्', 'regional' => 'sa_IN'],
        'hi'          => ['name' => 'Hindi',                  'script' => 'Deva', 'native' => 'हिन्दी', 'regional' => 'hi_IN'],
        'as'          => ['name' => 'Assamese',               'script' => 'Beng', 'native' => 'অসমীয়া', 'regional' => 'as_IN'],
        'bn'          => ['name' => 'Bengali',                'script' => 'Beng', 'native' => 'বাংলা', 'regional' => 'bn_BD'],
        'mni'         => ['name' => 'Manipuri',               'script' => 'Beng', 'native' => 'মৈতৈ', 'regional' => 'mni_IN'],
        'pa'          => ['name' => 'Punjabi (Gurmukhi)',     'script' => 'Guru', 'native' => 'ਪੰਜਾਬੀ', 'regional' => 'pa_IN'],
        'gu'          => ['name' => 'Gujarati',               'script' => 'Gujr', 'native' => 'ગુજરાતી', 'regional' => 'gu_IN'],
        'or'          => ['name' => 'Oriya',                  'script' => 'Orya', 'native' => 'ଓଡ଼ିଆ', 'regional' => 'or_IN'],
        'ta'          => ['name' => 'Tamil',                  'script' => 'Taml', 'native' => 'தமிழ்', 'regional' => 'ta_IN'],
        'te'          => ['name' => 'Telugu',                 'script' => 'Telu', 'native' => 'తెలుగు', 'regional' => 'te_IN'],
        'kn'          => ['name' => 'Kannada',                'script' => 'Knda', 'native' => 'ಕನ್ನಡ', 'regional' => 'kn_IN'],
        'ml'          => ['name' => 'Malayalam',              'script' => 'Mlym', 'native' => 'മലയാളം', 'regional' => 'ml_IN'],
        'si'          => ['name' => 'Sinhala',                'script' => 'Sinh', 'native' => 'සිංහල', 'regional' => 'si_LK'],
        'th'          => ['name' => 'Thai',                   'script' => 'Thai', 'native' => 'ไทย', 'regional' => 'th_TH'],
        'lo'          => ['name' => 'Lao',                    'script' => 'Laoo', 'native' => 'ລາວ', 'regional' => 'lo_LA'],
        'bo'          => ['name' => 'Tibetan',                'script' => 'Tibt', 'native' => 'པོད་སྐད་', 'regional' => 'bo_IN'],
        'dz'          => ['name' => 'Dzongkha',               'script' => 'Tibt', 'native' => 'རྫོང་ཁ', 'regional' => 'dz_BT'],
        'my'          => ['name' => 'Burmese',                'script' => 'Mymr', 'native' => 'မြန်မာဘာသာ', 'regional' => 'my_MM'],
        'ka'          => ['name' => 'Georgian',               'script' => 'Geor', 'native' => 'ქართული', 'regional' => 'ka_GE'],
        'byn'         => ['name' => 'Blin',                   'script' => 'Ethi', 'native' => 'ብሊን', 'regional' => 'byn_ER'],
        'tig'         => ['name' => 'Tigre',                  'script' => 'Ethi', 'native' => 'ትግረ', 'regional' => 'tig_ER'],
        'ti'          => ['name' => 'Tigrinya',               'script' => 'Ethi', 'native' => 'ትግርኛ', 'regional' => 'ti_ET'],
        'am'          => ['name' => 'Amharic',                'script' => 'Ethi', 'native' => 'አማርኛ', 'regional' => 'am_ET'],
        'wal'         => ['name' => 'Wolaytta',               'script' => 'Ethi', 'native' => 'ወላይታቱ', 'regional' => 'wal_ET'],
        'chr'         => ['name' => 'Cherokee',               'script' => 'Cher', 'native' => 'ᏣᎳᎩ', 'regional' => ''],
        'iu'          => ['name' => 'Inuktitut (Canadian Aboriginal Syllabics)', 'script' => 'Cans', 'native' => 'ᐃᓄᒃᑎᑐᑦ', 'regional' => 'iu_CA'],
        'oj'          => ['name' => 'Ojibwa',                 'script' => 'Cans', 'native' => 'ᐊᓂᔑᓈᐯᒧᐎᓐ', 'regional' => ''],
        'cr'          => ['name' => 'Cree',                   'script' => 'Cans', 'native' => 'ᓀᐦᐃᔭᐍᐏᐣ', 'regional' => ''],
        'km'          => ['name' => 'Khmer',                  'script' => 'Khmr', 'native' => 'ភាសាខ្មែរ', 'regional' => 'km_KH'],
        'mn-Mong'     => ['name' => 'Mongolian (Mongolian)',  'script' => 'Mong', 'native' => 'ᠮᠣᠨᠭᠭᠣᠯ ᠬᠡᠯᠡ', 'regional' => 'mn_MN'],
        'shi-Tfng'    => ['name' => 'Tachelhit (Tifinagh)',   'script' => 'Tfng', 'native' => 'ⵜⴰⵎⴰⵣⵉⵖⵜ', 'regional' => ''],
        'tzm'         => ['name' => 'Central Atlas Tamazight (Tifinagh)', 'script' => 'Tfng', 'native' => 'ⵜⴰⵎⴰⵣⵉⵖⵜ', 'regional' => ''],
        'yue'         => ['name' => 'Yue',                    'script' => 'Hant', 'native' => '廣州話', 'regional' => 'yue_HK'],
        'ja'          => ['name' => 'Japanese',               'script' => 'Jpan', 'native' => '日本語', 'regional' => 'ja_JP'],
        'zh'          => ['name' => 'Chinese (Simplified)',   'script' => 'Hans', 'native' => '简体中文', 'regional' => 'zh_CN'],
        'zh-Hant'     => ['name' => 'Chinese (Traditional)',  'script' => 'Hant', 'native' => '繁體中文', 'regional' => 'zh_CN'],
        'ii'          => ['name' => 'Sichuan Yi',             'script' => 'Yiii', 'native' => 'ꆈꌠꉙ', 'regional' => ''],
        'vai'         => ['name' => 'Vai (Vai)',              'script' => 'Vaii', 'native' => 'ꕙꔤ', 'regional' => ''],
        'jv-Java'     => ['name' => 'Javanese (Javanese)',    'script' => 'Java', 'native' => 'ꦧꦱꦗꦮ', 'regional' => ''],
        'ko'          => ['name' => 'Korean',                 'script' => 'Hang', 'native' => '한국어', 'regional' => 'ko_KR'],
    ],

    // Requires middleware `LaravelSessionRedirect.php`.
    //
    // Automatically determine locale from browser (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept-Language)
    // on first call if it's not defined in the URL. Redirect user to computed localized url.
    // For example, if users browser language is `de`, and `de` is active in the array `supportedLocales`,
    // the `/about` would be redirected to `/de/about`.
    //
    // The locale will be stored in session and only be computed from browser
    // again if the session expires.
    //
    // If false, system will take app.php locale attribute
    'useAcceptLanguageHeader' => false,

    // If `hideDefaultLocaleInURL` is true, then a url without locale
    // is identical with the same url with default locale.
    // For example, if `en` is default locale, then `/en/about` and `/about`
    // would be identical.
    //
    // If in addition the middleware `LaravelLocalizationRedirectFilter` is active, then
    // every url with default locale is redirected to url without locale.
    // For example, `/en/about` would be redirected to `/about`.
    // It is recommended to use `hideDefaultLocaleInURL` only in
    // combination with the middleware `LaravelLocalizationRedirectFilter`
    // to avoid duplicate content (SEO).
    //
    // If `useAcceptLanguageHeader` is true, then the first time
    // the locale will be determined from browser and redirect to that language.
    // After that, `hideDefaultLocaleInURL` behaves as usual.
    'hideDefaultLocaleInURL' => true,

    // If you want to display the locales in particular order in the language selector you should write the order here.
    // CAUTION: Please consider using the appropriate locale code otherwise it will not work
    // Example: 'localesOrder' => ['es','en'],
    'localesOrder' => [],

    //  If you want to use custom lang url segments like 'at' instead of 'de-AT', you can use the mapping to tallow the LanguageNegotiator to assign the descired locales based on HTTP Accept Language Header. For example you want ot use 'at', so map HTTP Accept Language Header 'de-AT' to 'at' (['de-AT' => 'at']).
    'localesMapping' => [],

    // Locale suffix for LC_TIME and LC_MONETARY
    // Defaults to most common ".UTF-8". Set to blank on Windows systems, change to ".utf8" on CentOS and similar.
    'utf8suffix' => env('LARAVELLOCALIZATION_UTF8SUFFIX', '.UTF-8'),

    // URLs which should not be processed, e.g. '/nova', '/nova/*', '/nova-api/*' or specific application URLs
    // Defaults to []
    'urlsIgnored' => ['/skipped'],

    'httpMethodsIgnored' => ['POST', 'PUT', 'PATCH', 'DELETE'],

    'countries' => [

        // Records 01-99 (Afghanistan to India)

        ['iso' => 'AF', 'name' => 'Afghanistan', 'iso3' => 'AFG', 'numcode' => '4', 'phonecode' => '93'],
        ['iso' => 'AL', 'name' => 'Albania', 'iso3' => 'ALB', 'numcode' => '8', 'phonecode' => '355'],
        ['iso' => 'DZ', 'name' => 'Algeria', 'iso3' => 'DZA', 'numcode' => '12', 'phonecode' => '213'],
        ['iso' => 'AS', 'name' => 'American Samoa', 'iso3' => 'ASM', 'numcode' => '16', 'phonecode' => '1684'],
        ['iso' => 'AD', 'name' => 'Andorra', 'iso3' => 'AND', 'numcode' => '20', 'phonecode' => '376'],
        ['iso' => 'AO', 'name' => 'Angola', 'iso3' => 'AGO', 'numcode' => '24', 'phonecode' => '244'],
        ['iso' => 'AI', 'name' => 'Anguilla', 'iso3' => 'AIA', 'numcode' => '660', 'phonecode' => '1264'],
        ['iso' => 'AQ', 'name' => 'Antarctica', 'iso3' => null, 'numcode' => null, 'phonecode' => '0'],
        ['iso' => 'AG', 'name' => 'Antigua and Barbuda', 'iso3' => 'ATG', 'numcode' => '28', 'phonecode' => '1268'],
        ['iso' => 'AR', 'name' => 'Argentina', 'iso3' => 'ARG', 'numcode' => '32', 'phonecode' => '54'],
        ['iso' => 'AM', 'name' => 'Armenia', 'iso3' => 'ARM', 'numcode' => '51', 'phonecode' => '374'],
        ['iso' => 'AW', 'name' => 'Aruba', 'iso3' => 'ABW', 'numcode' => '533', 'phonecode' => '297'],
        ['iso' => 'AU', 'name' => 'Australia', 'iso3' => 'AUS', 'numcode' => '36', 'phonecode' => '61'],
        ['iso' => 'AT', 'name' => 'Austria', 'iso3' => 'AUT', 'numcode' => '40', 'phonecode' => '43'],
        ['iso' => 'AZ', 'name' => 'Azerbaijan', 'iso3' => 'AZE', 'numcode' => '31', 'phonecode' => '994'],
        ['iso' => 'BS', 'name' => 'Bahamas', 'iso3' => 'BHS', 'numcode' => '44', 'phonecode' => '1242'],
        ['iso' => 'BH', 'name' => 'Bahrain', 'iso3' => 'BHR', 'numcode' => '48', 'phonecode' => '973'],
        ['iso' => 'BD', 'name' => 'Bangladesh', 'iso3' => 'BGD', 'numcode' => '50', 'phonecode' => '880'],
        ['iso' => 'BB', 'name' => 'Barbados', 'iso3' => 'BRB', 'numcode' => '52', 'phonecode' => '1246'],
        ['iso' => 'BY', 'name' => 'Belarus', 'iso3' => 'BLR', 'numcode' => '112', 'phonecode' => '375'],
        ['iso' => 'BE', 'name' => 'Belgium', 'iso3' => 'BEL', 'numcode' => '56', 'phonecode' => '32'],
        ['iso' => 'BZ', 'name' => 'Belize', 'iso3' => 'BLZ', 'numcode' => '84', 'phonecode' => '501'],
        ['iso' => 'BJ', 'name' => 'Benin', 'iso3' => 'BEN', 'numcode' => '204', 'phonecode' => '229'],
        ['iso' => 'BM', 'name' => 'Bermuda', 'iso3' => 'BMU', 'numcode' => '60', 'phonecode' => '1441'],
        ['iso' => 'BT', 'name' => 'Bhutan', 'iso3' => 'BTN', 'numcode' => '64', 'phonecode' => '975'],
        ['iso' => 'BO', 'name' => 'Bolivia', 'iso3' => 'BOL', 'numcode' => '68', 'phonecode' => '591'],
        ['iso' => 'BA', 'name' => 'Bosnia and Herzegovina', 'iso3' => 'BIH', 'numcode' => '70', 'phonecode' => '387'],
        ['iso' => 'BW', 'name' => 'Botswana', 'iso3' => 'BWA', 'numcode' => '72', 'phonecode' => '267'],
        ['iso' => 'BV', 'name' => 'Bouvet Island', 'iso3' => null, 'numcode' => null, 'phonecode' => '0'],
        ['iso' => 'BR', 'name' => 'Brazil', 'iso3' => 'BRA', 'numcode' => '76', 'phonecode' => '55'],
        ['iso' => 'IO', 'name' => 'British Indian Ocean Territory', 'iso3' => null, 'numcode' => null, 'phonecode' => '246'],
        ['iso' => 'BN', 'name' => 'Brunei Darussalam', 'iso3' => 'BRN', 'numcode' => '96', 'phonecode' => '673'],
        ['iso' => 'BG', 'name' => 'Bulgaria', 'iso3' => 'BGR', 'numcode' => '100', 'phonecode' => '359'],
        ['iso' => 'BF', 'name' => 'Burkina Faso', 'iso3' => 'BFA', 'numcode' => '854', 'phonecode' => '226'],
        ['iso' => 'BI', 'name' => 'Burundi', 'iso3' => 'BDI', 'numcode' => '108', 'phonecode' => '257'],
        ['iso' => 'KH', 'name' => 'Cambodia', 'iso3' => 'KHM', 'numcode' => '116', 'phonecode' => '855'],
        ['iso' => 'CM', 'name' => 'Cameroon', 'iso3' => 'CMR', 'numcode' => '120', 'phonecode' => '237'],
        ['iso' => 'CA', 'name' => 'Canada', 'iso3' => 'CAN', 'numcode' => '124', 'phonecode' => '1'],
        ['iso' => 'CV', 'name' => 'Cape Verde', 'iso3' => 'CPV', 'numcode' => '132', 'phonecode' => '238'],
        ['iso' => 'KY', 'name' => 'Cayman Islands', 'iso3' => 'CYM', 'numcode' => '136', 'phonecode' => '1345'],
        ['iso' => 'CF', 'name' => 'Central African Republic', 'iso3' => 'CAF', 'numcode' => '140', 'phonecode' => '236'],
        ['iso' => 'TD', 'name' => 'Chad', 'iso3' => 'TCD', 'numcode' => '148', 'phonecode' => '235'],
        ['iso' => 'CL', 'name' => 'Chile', 'iso3' => 'CHL', 'numcode' => '152', 'phonecode' => '56'],
        ['iso' => 'CN', 'name' => 'China', 'iso3' => 'CHN', 'numcode' => '156', 'phonecode' => '86'],
        ['iso' => 'CX', 'name' => 'Christmas Island', 'iso3' => null, 'numcode' => null, 'phonecode' => '61'],
        ['iso' => 'CC', 'name' => 'Cocos (Keeling) Islands', 'iso3' => null, 'numcode' => null, 'phonecode' => '672'],
        ['iso' => 'CO', 'name' => 'Colombia', 'iso3' => 'COL', 'numcode' => '170', 'phonecode' => '57'],
        ['iso' => 'KM', 'name' => 'Comoros', 'iso3' => 'COM', 'numcode' => '174', 'phonecode' => '269'],
        ['iso' => 'CG', 'name' => 'Congo', 'iso3' => 'COG', 'numcode' => '178', 'phonecode' => '242'],
        ['iso' => 'CD', 'name' => 'Congo, the Democratic Republic of the', 'iso3' => 'COD', 'numcode' => '180', 'phonecode' => '242'],
        ['iso' => 'CK', 'name' => 'Cook Islands', 'iso3' => 'COK', 'numcode' => '184', 'phonecode' => '682'],
        ['iso' => 'CR', 'name' => 'Costa Rica', 'iso3' => 'CRI', 'numcode' => '188', 'phonecode' => '506'],
        ['iso' => 'CI', 'name' => 'Cote D\'Ivoire', 'iso3' => 'CIV', 'numcode' => '384', 'phonecode' => '225'],
        ['iso' => 'HR', 'name' => 'Croatia', 'iso3' => 'HRV', 'numcode' => '191', 'phonecode' => '385'],
        ['iso' => 'CU', 'name' => 'Cuba', 'iso3' => 'CUB', 'numcode' => '192', 'phonecode' => '53'],
        ['iso' => 'CY', 'name' => 'Cyprus', 'iso3' => 'CYP', 'numcode' => '196', 'phonecode' => '357'],
        ['iso' => 'CZ', 'name' => 'Czech Republic', 'iso3' => 'CZE', 'numcode' => '203', 'phonecode' => '420'],
        ['iso' => 'DK', 'name' => 'Denmark', 'iso3' => 'DNK', 'numcode' => '208', 'phonecode' => '45'],
        ['iso' => 'DJ', 'name' => 'Djibouti', 'iso3' => 'DJI', 'numcode' => '262', 'phonecode' => '253'],
        ['iso' => 'DM', 'name' => 'Dominica', 'iso3' => 'DMA', 'numcode' => '212', 'phonecode' => '1767'],
        ['iso' => 'DO', 'name' => 'Dominican Republic', 'iso3' => 'DOM', 'numcode' => '214', 'phonecode' => '1809'],
        ['iso' => 'EC', 'name' => 'Ecuador', 'iso3' => 'ECU', 'numcode' => '218', 'phonecode' => '593'],
        ['iso' => 'EG', 'name' => 'Egypt', 'iso3' => 'EGY', 'numcode' => '818', 'phonecode' => '20'],
        ['iso' => 'SV', 'name' => 'El Salvador', 'iso3' => 'SLV', 'numcode' => '222', 'phonecode' => '503'],
        ['iso' => 'GQ', 'name' => 'Equatorial Guinea', 'iso3' => 'GNQ', 'numcode' => '226', 'phonecode' => '240'],
        ['iso' => 'ER', 'name' => 'Eritrea', 'iso3' => 'ERI', 'numcode' => '232', 'phonecode' => '291'],
        ['iso' => 'EE', 'name' => 'Estonia', 'iso3' => 'EST', 'numcode' => '233', 'phonecode' => '372'],
        ['iso' => 'ET', 'name' => 'Ethiopia', 'iso3' => 'ETH', 'numcode' => '231', 'phonecode' => '251'],
        ['iso' => 'FK', 'name' => 'Falkland Islands (Malvinas)', 'iso3' => 'FLK', 'numcode' => '238', 'phonecode' => '500'],
        ['iso' => 'FO', 'name' => 'Faroe Islands', 'iso3' => 'FRO', 'numcode' => '234', 'phonecode' => '298'],
        ['iso' => 'FJ', 'name' => 'Fiji', 'iso3' => 'FJI', 'numcode' => '242', 'phonecode' => '679'],
        ['iso' => 'FI', 'name' => 'Finland', 'iso3' => 'FIN', 'numcode' => '246', 'phonecode' => '358'],
        ['iso' => 'FR', 'name' => 'France', 'iso3' => 'FRA', 'numcode' => '250', 'phonecode' => '33'],
        ['iso' => 'GF', 'name' => 'French Guiana', 'iso3' => 'GUF', 'numcode' => '254', 'phonecode' => '594'],
        ['iso' => 'PF', 'name' => 'French Polynesia', 'iso3' => 'PYF', 'numcode' => '258', 'phonecode' => '689'],
        ['iso' => 'TF', 'name' => 'French Southern Territories', 'iso3' => null, 'numcode' => null, 'phonecode' => '0'],
        ['iso' => 'GA', 'name' => 'Gabon', 'iso3' => 'GAB', 'numcode' => '266', 'phonecode' => '241'],
        ['iso' => 'GM', 'name' => 'Gambia', 'iso3' => 'GMB', 'numcode' => '270', 'phonecode' => '220'],
        ['iso' => 'GE', 'name' => 'Georgia', 'iso3' => 'GEO', 'numcode' => '268', 'phonecode' => '995'],
        ['iso' => 'DE', 'name' => 'Germany', 'iso3' => 'DEU', 'numcode' => '276', 'phonecode' => '49'],
        ['iso' => 'GH', 'name' => 'Ghana', 'iso3' => 'GHA', 'numcode' => '288', 'phonecode' => '233'],
        ['iso' => 'GI', 'name' => 'Gibraltar', 'iso3' => 'GIB', 'numcode' => '292', 'phonecode' => '350'],
        ['iso' => 'GR', 'name' => 'Greece', 'iso3' => 'GRC', 'numcode' => '300', 'phonecode' => '30'],
        ['iso' => 'GL', 'name' => 'Greenland', 'iso3' => 'GRL', 'numcode' => '304', 'phonecode' => '299'],
        ['iso' => 'GD', 'name' => 'Grenada', 'iso3' => 'GRD', 'numcode' => '308', 'phonecode' => '1473'],
        ['iso' => 'GP', 'name' => 'Guadeloupe', 'iso3' => 'GLP', 'numcode' => '312', 'phonecode' => '590'],
        ['iso' => 'GU', 'name' => 'Guam', 'iso3' => 'GUM', 'numcode' => '316', 'phonecode' => '1671'],
        ['iso' => 'GT', 'name' => 'Guatemala', 'iso3' => 'GTM', 'numcode' => '320', 'phonecode' => '502'],
        ['iso' => 'GN', 'name' => 'Guinea', 'iso3' => 'GIN', 'numcode' => '324', 'phonecode' => '224'],
        ['iso' => 'GW', 'name' => 'Guinea-Bissau', 'iso3' => 'GNB', 'numcode' => '624', 'phonecode' => '245'],
        ['iso' => 'GY', 'name' => 'Guyana', 'iso3' => 'GUY', 'numcode' => '328', 'phonecode' => '592'],
        ['iso' => 'HT', 'name' => 'Haiti', 'iso3' => 'HTI', 'numcode' => '332', 'phonecode' => '509'],
        ['iso' => 'HM', 'name' => 'Heard Island and Mcdonald Islands', 'iso3' => null, 'numcode' => null, 'phonecode' => '0'],
        ['iso' => 'VA', 'name' => 'Holy See (Vatican City State)', 'iso3' => 'VAT', 'numcode' => '336', 'phonecode' => '39'],
        ['iso' => 'HN', 'name' => 'Honduras', 'iso3' => 'HND', 'numcode' => '340', 'phonecode' => '504'],
        ['iso' => 'HK', 'name' => 'Hong Kong', 'iso3' => 'HKG', 'numcode' => '344', 'phonecode' => '852'],
        ['iso' => 'HU', 'name' => 'Hungary', 'iso3' => 'HUN', 'numcode' => '348', 'phonecode' => '36'],
        ['iso' => 'IS', 'name' => 'Iceland', 'iso3' => 'ISL', 'numcode' => '352', 'phonecode' => '354'],
        ['iso' => 'IN', 'name' => 'India', 'iso3' => 'IND', 'numcode' => '356', 'phonecode' => '91'],

        // Records 100-199 (Indonesia to Spain)

        ['iso' => 'ID', 'name' => 'Indonesia', 'iso3' => 'IDN', 'numcode' => '360', 'phonecode' => '62'],
        ['iso' => 'IR', 'name' => 'Iran, Islamic Republic of', 'iso3' => 'IRN', 'numcode' => '364', 'phonecode' => '98'],
        ['iso' => 'IQ', 'name' => 'Iraq', 'iso3' => 'IRQ', 'numcode' => '368', 'phonecode' => '964'],
        ['iso' => 'IE', 'name' => 'Ireland', 'iso3' => 'IRL', 'numcode' => '372', 'phonecode' => '353'],
        ['iso' => 'IL', 'name' => 'Israel', 'iso3' => 'ISR', 'numcode' => '376', 'phonecode' => '972'],
        ['iso' => 'IT', 'name' => 'Italy', 'iso3' => 'ITA', 'numcode' => '380', 'phonecode' => '39'],
        ['iso' => 'JM', 'name' => 'Jamaica', 'iso3' => 'JAM', 'numcode' => '388', 'phonecode' => '1876'],
        ['iso' => 'JP', 'name' => 'Japan', 'iso3' => 'JPN', 'numcode' => '392', 'phonecode' => '81'],
        ['iso' => 'JO', 'name' => 'Jordan', 'iso3' => 'JOR', 'numcode' => '400', 'phonecode' => '962'],
        ['iso' => 'KZ', 'name' => 'Kazakhstan', 'iso3' => 'KAZ', 'numcode' => '398', 'phonecode' => '7'],
        ['iso' => 'KE', 'name' => 'Kenya', 'iso3' => 'KEN', 'numcode' => '404', 'phonecode' => '254'],
        ['iso' => 'KI', 'name' => 'Kiribati', 'iso3' => 'KIR', 'numcode' => '296', 'phonecode' => '686'],
        ['iso' => 'KP', 'name' => 'Korea, Democratic People\'s Republic of', 'iso3' => 'PRK', 'numcode' => '408', 'phonecode' => '850'],
        ['iso' => 'KR', 'name' => 'Korea, Republic of', 'iso3' => 'KOR', 'numcode' => '410', 'phonecode' => '82'],
        ['iso' => 'KW', 'name' => 'Kuwait', 'iso3' => 'KWT', 'numcode' => '414', 'phonecode' => '965'],
        ['iso' => 'KG', 'name' => 'Kyrgyzstan', 'iso3' => 'KGZ', 'numcode' => '417', 'phonecode' => '996'],
        ['iso' => 'LA', 'name' => 'Lao People\'s Democratic Republic', 'iso3' => 'LAO', 'numcode' => '418', 'phonecode' => '856'],
        ['iso' => 'LV', 'name' => 'Latvia', 'iso3' => 'LVA', 'numcode' => '428', 'phonecode' => '371'],
        ['iso' => 'LB', 'name' => 'Lebanon', 'iso3' => 'LBN', 'numcode' => '422', 'phonecode' => '961'],
        ['iso' => 'LS', 'name' => 'Lesotho', 'iso3' => 'LSO', 'numcode' => '426', 'phonecode' => '266'],
        ['iso' => 'LR', 'name' => 'Liberia', 'iso3' => 'LBR', 'numcode' => '430', 'phonecode' => '231'],
        ['iso' => 'LY', 'name' => 'Libyan Arab Jamahiriya', 'iso3' => 'LBY', 'numcode' => '434', 'phonecode' => '218'],
        ['iso' => 'LI', 'name' => 'Liechtenstein', 'iso3' => 'LIE', 'numcode' => '438', 'phonecode' => '423'],
        ['iso' => 'LT', 'name' => 'Lithuania', 'iso3' => 'LTU', 'numcode' => '440', 'phonecode' => '370'],
        ['iso' => 'LU', 'name' => 'Luxembourg', 'iso3' => 'LUX', 'numcode' => '442', 'phonecode' => '352'],
        ['iso' => 'MO', 'name' => 'Macao', 'iso3' => 'MAC', 'numcode' => '446', 'phonecode' => '853'],
        ['iso' => 'MK', 'name' => 'Macedonia, the Former Yugoslav Republic of', 'iso3' => 'MKD', 'numcode' => '807', 'phonecode' => '389'],
        ['iso' => 'MG', 'name' => 'Madagascar', 'iso3' => 'MDG', 'numcode' => '450', 'phonecode' => '261'],
        ['iso' => 'MW', 'name' => 'Malawi', 'iso3' => 'MWI', 'numcode' => '454', 'phonecode' => '265'],
        ['iso' => 'MY', 'name' => 'Malaysia', 'iso3' => 'MYS', 'numcode' => '458', 'phonecode' => '60'],
        ['iso' => 'MV', 'name' => 'Maldives', 'iso3' => 'MDV', 'numcode' => '462', 'phonecode' => '960'],
        ['iso' => 'ML', 'name' => 'Mali', 'iso3' => 'MLI', 'numcode' => '466', 'phonecode' => '223'],
        ['iso' => 'MT', 'name' => 'Malta', 'iso3' => 'MLT', 'numcode' => '470', 'phonecode' => '356'],
        ['iso' => 'MH', 'name' => 'Marshall Islands', 'iso3' => 'MHL', 'numcode' => '584', 'phonecode' => '692'],
        ['iso' => 'MQ', 'name' => 'Martinique', 'iso3' => 'MTQ', 'numcode' => '474', 'phonecode' => '596'],
        ['iso' => 'MR', 'name' => 'Mauritania', 'iso3' => 'MRT', 'numcode' => '478', 'phonecode' => '222'],
        ['iso' => 'MU', 'name' => 'Mauritius', 'iso3' => 'MUS', 'numcode' => '480', 'phonecode' => '230'],
        ['iso' => 'YT', 'name' => 'Mayotte', 'iso3' => null, 'numcode' => null, 'phonecode' => '269'],
        ['iso' => 'MX', 'name' => 'Mexico', 'iso3' => 'MEX', 'numcode' => '484', 'phonecode' => '52'],
        ['iso' => 'FM', 'name' => 'Micronesia, Federated States of', 'iso3' => 'FSM', 'numcode' => '583', 'phonecode' => '691'],
        ['iso' => 'MD', 'name' => 'Moldova, Republic of', 'iso3' => 'MDA', 'numcode' => '498', 'phonecode' => '373'],
        ['iso' => 'MC', 'name' => 'Monaco', 'iso3' => 'MCO', 'numcode' => '492', 'phonecode' => '377'],
        ['iso' => 'MN', 'name' => 'Mongolia', 'iso3' => 'MNG', 'numcode' => '496', 'phonecode' => '976'],
        ['iso' => 'MS', 'name' => 'Montserrat', 'iso3' => 'MSR', 'numcode' => '500', 'phonecode' => '1664'],
        ['iso' => 'MA', 'name' => 'Morocco', 'iso3' => 'MAR', 'numcode' => '504', 'phonecode' => '212'],
        ['iso' => 'MZ', 'name' => 'Mozambique', 'iso3' => 'MOZ', 'numcode' => '508', 'phonecode' => '258'],
        ['iso' => 'MM', 'name' => 'Myanmar', 'iso3' => 'MMR', 'numcode' => '104', 'phonecode' => '95'],
        ['iso' => 'NA', 'name' => 'Namibia', 'iso3' => 'NAM', 'numcode' => '516', 'phonecode' => '264'],
        ['iso' => 'NR', 'name' => 'Nauru', 'iso3' => 'NRU', 'numcode' => '520', 'phonecode' => '674'],
        ['iso' => 'NP', 'name' => 'Nepal', 'iso3' => 'NPL', 'numcode' => '524', 'phonecode' => '977'],
        ['iso' => 'NL', 'name' => 'Netherlands', 'iso3' => 'NLD', 'numcode' => '528', 'phonecode' => '31'],
        ['iso' => 'AN', 'name' => 'Netherlands Antilles', 'iso3' => 'ANT', 'numcode' => '530', 'phonecode' => '599'],
        ['iso' => 'NC', 'name' => 'New Caledonia', 'iso3' => 'NCL', 'numcode' => '540', 'phonecode' => '687'],
        ['iso' => 'NZ', 'name' => 'New Zealand', 'iso3' => 'NZL', 'numcode' => '554', 'phonecode' => '64'],
        ['iso' => 'NI', 'name' => 'Nicaragua', 'iso3' => 'NIC', 'numcode' => '558', 'phonecode' => '505'],
        ['iso' => 'NE', 'name' => 'Niger', 'iso3' => 'NER', 'numcode' => '562', 'phonecode' => '227'],
        ['iso' => 'NG', 'name' => 'Nigeria', 'iso3' => 'NGA', 'numcode' => '566', 'phonecode' => '234'],
        ['iso' => 'NU', 'name' => 'Niue', 'iso3' => 'NIU', 'numcode' => '570', 'phonecode' => '683'],
        ['iso' => 'NF', 'name' => 'Norfolk Island', 'iso3' => 'NFK', 'numcode' => '574', 'phonecode' => '672'],
        ['iso' => 'MP', 'name' => 'Northern Mariana Islands', 'iso3' => 'MNP', 'numcode' => '580', 'phonecode' => '1670'],
        ['iso' => 'NO', 'name' => 'Norway', 'iso3' => 'NOR', 'numcode' => '578', 'phonecode' => '47'],
        ['iso' => 'OM', 'name' => 'Oman', 'iso3' => 'OMN', 'numcode' => '512', 'phonecode' => '968'],
        ['iso' => 'PK', 'name' => 'Pakistan', 'iso3' => 'PAK', 'numcode' => '586', 'phonecode' => '92'],
        ['iso' => 'PW', 'name' => 'Palau', 'iso3' => 'PLW', 'numcode' => '585', 'phonecode' => '680'],
        ['iso' => 'PS', 'name' => 'Palestinian Territory, Occupied', 'iso3' => null, 'numcode' => null, 'phonecode' => '970'],
        ['iso' => 'PA', 'name' => 'Panama', 'iso3' => 'PAN', 'numcode' => '591', 'phonecode' => '507'],
        ['iso' => 'PG', 'name' => 'Papua New Guinea', 'iso3' => 'PNG', 'numcode' => '598', 'phonecode' => '675'],
        ['iso' => 'PY', 'name' => 'Paraguay', 'iso3' => 'PRY', 'numcode' => '600', 'phonecode' => '595'],
        ['iso' => 'PE', 'name' => 'Peru', 'iso3' => 'PER', 'numcode' => '604', 'phonecode' => '51'],
        ['iso' => 'PH', 'name' => 'Philippines', 'iso3' => 'PHL', 'numcode' => '608', 'phonecode' => '63'],
        ['iso' => 'PN', 'name' => 'Pitcairn', 'iso3' => 'PCN', 'numcode' => '612', 'phonecode' => '0'],
        ['iso' => 'PL', 'name' => 'Poland', 'iso3' => 'POL', 'numcode' => '616', 'phonecode' => '48'],
        ['iso' => 'PT', 'name' => 'Portugal', 'iso3' => 'PRT', 'numcode' => '620', 'phonecode' => '351'],
        ['iso' => 'PR', 'name' => 'Puerto Rico', 'iso3' => 'PRI', 'numcode' => '630', 'phonecode' => '1787'],
        ['iso' => 'QA', 'name' => 'Qatar', 'iso3' => 'QAT', 'numcode' => '634', 'phonecode' => '974'],
        ['iso' => 'RE', 'name' => 'Reunion', 'iso3' => 'REU', 'numcode' => '638', 'phonecode' => '262'],
        ['iso' => 'RO', 'name' => 'Romania', 'iso3' => 'ROM', 'numcode' => '642', 'phonecode' => '40'],
        ['iso' => 'RU', 'name' => 'Russian Federation', 'iso3' => 'RUS', 'numcode' => '643', 'phonecode' => '70'],
        ['iso' => 'RW', 'name' => 'Rwanda', 'iso3' => 'RWA', 'numcode' => '646', 'phonecode' => '250'],
        ['iso' => 'SH', 'name' => 'Saint Helena', 'iso3' => 'SHN', 'numcode' => '654', 'phonecode' => '290'],
        ['iso' => 'KN', 'name' => 'Saint Kitts and Nevis', 'iso3' => 'KNA', 'numcode' => '659', 'phonecode' => '1869'],
        ['iso' => 'LC', 'name' => 'Saint Lucia', 'iso3' => 'LCA', 'numcode' => '662', 'phonecode' => '1758'],
        ['iso' => 'PM', 'name' => 'Saint Pierre and Miquelon', 'iso3' => 'SPM', 'numcode' => '666', 'phonecode' => '508'],
        ['iso' => 'VC', 'name' => 'Saint Vincent and the Grenadines', 'iso3' => 'VCT', 'numcode' => '670', 'phonecode' => '1784'],
        ['iso' => 'WS', 'name' => 'Samoa', 'iso3' => 'WSM', 'numcode' => '882', 'phonecode' => '684'],
        ['iso' => 'SM', 'name' => 'San Marino', 'iso3' => 'SMR', 'numcode' => '674', 'phonecode' => '378'],
        ['iso' => 'ST', 'name' => 'Sao Tome and Principe', 'iso3' => 'STP', 'numcode' => '678', 'phonecode' => '239'],
        ['iso' => 'SA', 'name' => 'Saudi Arabia', 'iso3' => 'SAU', 'numcode' => '682', 'phonecode' => '966'],
        ['iso' => 'SN', 'name' => 'Senegal', 'iso3' => 'SEN', 'numcode' => '686', 'phonecode' => '221'],
        ['iso' => 'CS', 'name' => 'Serbia and Montenegro', 'iso3' => null, 'numcode' => null, 'phonecode' => '381'],
        ['iso' => 'SC', 'name' => 'Seychelles', 'iso3' => 'SYC', 'numcode' => '690', 'phonecode' => '248'],
        ['iso' => 'SL', 'name' => 'Sierra Leone', 'iso3' => 'SLE', 'numcode' => '694', 'phonecode' => '232'],
        ['iso' => 'SG', 'name' => 'Singapore', 'iso3' => 'SGP', 'numcode' => '702', 'phonecode' => '65'],
        ['iso' => 'SK', 'name' => 'Slovakia', 'iso3' => 'SVK', 'numcode' => '703', 'phonecode' => '421'],
        ['iso' => 'SI', 'name' => 'Slovenia', 'iso3' => 'SVN', 'numcode' => '705', 'phonecode' => '386'],
        ['iso' => 'SB', 'name' => 'Solomon Islands', 'iso3' => 'SLB', 'numcode' => '90', 'phonecode' => '677'],
        ['iso' => 'SO', 'name' => 'Somalia', 'iso3' => 'SOM', 'numcode' => '706', 'phonecode' => '252'],
        ['iso' => 'ZA', 'name' => 'South Africa', 'iso3' => 'ZAF', 'numcode' => '710', 'phonecode' => '27'],
        ['iso' => 'GS', 'name' => 'South Georgia and the South Sandwich Islands', 'iso3' => null, 'numcode' => null, 'phonecode' => '0'],
        ['iso' => 'ES', 'name' => 'Spain', 'iso3' => 'ESP', 'numcode' => '724', 'phonecode' => '34'],

        // Records 200-253 (Sri Lanka to South Sudan)

        ['iso' => 'LK', 'name' => 'Sri Lanka', 'iso3' => 'LKA', 'numcode' => '144', 'phonecode' => '94'],
        ['iso' => 'SD', 'name' => 'Sudan', 'iso3' => 'SDN', 'numcode' => '736', 'phonecode' => '249'],
        ['iso' => 'SR', 'name' => 'Suriname', 'iso3' => 'SUR', 'numcode' => '740', 'phonecode' => '597'],
        ['iso' => 'SJ', 'name' => 'Svalbard and Jan Mayen', 'iso3' => 'SJM', 'numcode' => '744', 'phonecode' => '47'],
        ['iso' => 'SZ', 'name' => 'Swaziland', 'iso3' => 'SWZ', 'numcode' => '748', 'phonecode' => '268'],
        ['iso' => 'SE', 'name' => 'Sweden', 'iso3' => 'SWE', 'numcode' => '752', 'phonecode' => '46'],
        ['iso' => 'CH', 'name' => 'Switzerland', 'iso3' => 'CHE', 'numcode' => '756', 'phonecode' => '41'],
        ['iso' => 'SY', 'name' => 'Syrian Arab Republic', 'iso3' => 'SYR', 'numcode' => '760', 'phonecode' => '963'],
        ['iso' => 'TW', 'name' => 'Taiwan, Province of China', 'iso3' => 'TWN', 'numcode' => '158', 'phonecode' => '886'],
        ['iso' => 'TJ', 'name' => 'Tajikistan', 'iso3' => 'TJK', 'numcode' => '762', 'phonecode' => '992'],
        ['iso' => 'TZ', 'name' => 'Tanzania, United Republic of', 'iso3' => 'TZA', 'numcode' => '834', 'phonecode' => '255'],
        ['iso' => 'TH', 'name' => 'Thailand', 'iso3' => 'THA', 'numcode' => '764', 'phonecode' => '66'],
        ['iso' => 'TL', 'name' => 'Timor-Leste', 'iso3' => null, 'numcode' => null, 'phonecode' => '670'],
        ['iso' => 'TG', 'name' => 'Togo', 'iso3' => 'TGO', 'numcode' => '768', 'phonecode' => '228'],
        ['iso' => 'TK', 'name' => 'Tokelau', 'iso3' => 'TKL', 'numcode' => '772', 'phonecode' => '690'],
        ['iso' => 'TO', 'name' => 'Tonga', 'iso3' => 'TON', 'numcode' => '776', 'phonecode' => '676'],
        ['iso' => 'TT', 'name' => 'Trinidad and Tobago', 'iso3' => 'TTO', 'numcode' => '780', 'phonecode' => '1868'],
        ['iso' => 'TN', 'name' => 'Tunisia', 'iso3' => 'TUN', 'numcode' => '788', 'phonecode' => '216'],
        ['iso' => 'TR', 'name' => 'Turkey', 'iso3' => 'TUR', 'numcode' => '792', 'phonecode' => '90'],
        ['iso' => 'TM', 'name' => 'Turkmenistan', 'iso3' => 'TKM', 'numcode' => '795', 'phonecode' => '7370'],
        ['iso' => 'TC', 'name' => 'Turks and Caicos Islands', 'iso3' => 'TCA', 'numcode' => '796', 'phonecode' => '1649'],
        ['iso' => 'TV', 'name' => 'Tuvalu', 'iso3' => 'TUV', 'numcode' => '798', 'phonecode' => '688'],
        ['iso' => 'UG', 'name' => 'Uganda', 'iso3' => 'UGA', 'numcode' => '800', 'phonecode' => '256'],
        ['iso' => 'UA', 'name' => 'Ukraine', 'iso3' => 'UKR', 'numcode' => '804', 'phonecode' => '380'],
        ['iso' => 'AE', 'name' => 'United Arab Emirates', 'iso3' => 'ARE', 'numcode' => '784', 'phonecode' => '971'],
        ['iso' => 'GB', 'name' => 'United Kingdom', 'iso3' => 'GBR', 'numcode' => '826', 'phonecode' => '44'],
        ['iso' => 'US', 'name' => 'United States', 'iso3' => 'USA', 'numcode' => '840', 'phonecode' => '1'],
        ['iso' => 'UM', 'name' => 'United States Minor Outlying Islands', 'iso3' => null, 'numcode' => null, 'phonecode' => '1'],
        ['iso' => 'UY', 'name' => 'Uruguay', 'iso3' => 'URY', 'numcode' => '858', 'phonecode' => '598'],
        ['iso' => 'UZ', 'name' => 'Uzbekistan', 'iso3' => 'UZB', 'numcode' => '860', 'phonecode' => '998'],
        ['iso' => 'VU', 'name' => 'Vanuatu', 'iso3' => 'VUT', 'numcode' => '548', 'phonecode' => '678'],
        ['iso' => 'VE', 'name' => 'Venezuela', 'iso3' => 'VEN', 'numcode' => '862', 'phonecode' => '58'],
        ['iso' => 'VN', 'name' => 'Viet Nam', 'iso3' => 'VNM', 'numcode' => '704', 'phonecode' => '84'],
        ['iso' => 'VG', 'name' => 'Virgin Islands, British', 'iso3' => 'VGB', 'numcode' => '92', 'phonecode' => '1284'],
        ['iso' => 'VI', 'name' => 'Virgin Islands, U.S.', 'iso3' => 'VIR', 'numcode' => '850', 'phonecode' => '1340'],
        ['iso' => 'WF', 'name' => 'Wallis and Futuna', 'iso3' => 'WLF', 'numcode' => '876', 'phonecode' => '681'],
        ['iso' => 'EH', 'name' => 'Western Sahara', 'iso3' => 'ESH', 'numcode' => '732', 'phonecode' => '212'],
        ['iso' => 'YE', 'name' => 'Yemen', 'iso3' => 'YEM', 'numcode' => '887', 'phonecode' => '967'],
        ['iso' => 'ZM', 'name' => 'Zambia', 'iso3' => 'ZMB', 'numcode' => '894', 'phonecode' => '260'],
        ['iso' => 'ZW', 'name' => 'Zimbabwe', 'iso3' => 'ZWE', 'numcode' => '716', 'phonecode' => '263'],
        ['iso' => 'RS', 'name' => 'Serbia', 'iso3' => 'SRB', 'numcode' => '688', 'phonecode' => '381'],
        ['iso' => 'AP', 'name' => 'Asia / Pacific Region', 'iso3' => '0', 'numcode' => '0', 'phonecode' => '0'],
        ['iso' => 'ME', 'name' => 'Montenegro', 'iso3' => 'MNE', 'numcode' => '499', 'phonecode' => '382'],
        ['iso' => 'AX', 'name' => 'Aland Islands', 'iso3' => 'ALA', 'numcode' => '248', 'phonecode' => '358'],
        ['iso' => 'BQ', 'name' => 'Bonaire, Sint Eustatius and Saba', 'iso3' => 'BES', 'numcode' => '535', 'phonecode' => '599'],
        ['iso' => 'CW', 'name' => 'Curacao', 'iso3' => 'CUW', 'numcode' => '531', 'phonecode' => '599'],
        ['iso' => 'GG', 'name' => 'Guernsey', 'iso3' => 'GGY', 'numcode' => '831', 'phonecode' => '44'],
        ['iso' => 'IM', 'name' => 'Isle of Man', 'iso3' => 'IMN', 'numcode' => '833', 'phonecode' => '44'],
        ['iso' => 'JE', 'name' => 'Jersey', 'iso3' => 'JEY', 'numcode' => '832', 'phonecode' => '44'],
        ['iso' => 'XK', 'name' => 'Kosovo', 'iso3' => '---', 'numcode' => '0', 'phonecode' => '381'],
        ['iso' => 'BL', 'name' => 'Saint Barthelemy', 'iso3' => 'BLM', 'numcode' => '652', 'phonecode' => '590'],
        ['iso' => 'MF', 'name' => 'Saint Martin', 'iso3' => 'MAF', 'numcode' => '663', 'phonecode' => '590'],
        ['iso' => 'SX', 'name' => 'Sint Maarten', 'iso3' => 'SXM', 'numcode' => '534', 'phonecode' => '1'],
        ['iso' => 'SS', 'name' => 'South Sudan', 'iso3' => 'SSD', 'numcode' => '728', 'phonecode' => '211'],
    ],
];
